// RegisterReportDlg.cpp : implementation file
//

#include "stdafx.h"
#include "psat.h"
#include "RegisterReportDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRegisterReportDlg dialog


CRegisterReportDlg::CRegisterReportDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRegisterReportDlg::IDD, pParent) , m_rtTitleBar ( 1, 1, 272, 25 )
{
	//{{AFX_DATA_INIT(CRegisterReportDlg)
	m_strContent = _T("");
	//}}AFX_DATA_INIT
	m_bFirst = TRUE; 
}


void CRegisterReportDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRegisterReportDlg)
	DDX_Control(pDX, IDC_EDIT_CONTENTS, m_editContent);
	DDX_Control(pDX, IDC_BUTTON_REGISTER, m_btnRegister);
	DDX_Control(pDX, IDC_BUTTON_CANCEL, m_btnCancel);
	DDX_Text(pDX, IDC_EDIT_CONTENTS, m_strContent);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRegisterReportDlg, CDialog)
	//{{AFX_MSG_MAP(CRegisterReportDlg)
	ON_BN_CLICKED(IDC_BUTTON_REGISTER, OnButtonRegister)
	ON_BN_CLICKED(IDC_BUTTON_CANCEL, OnButtonCancel)
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRegisterReportDlg message handlers

void CRegisterReportDlg::OnButtonRegister() 
{
	UpdateData( TRUE );
	CDialog::OnOK();	
}

void CRegisterReportDlg::OnButtonCancel() 
{
	CDialog::OnCancel();	
}

BOOL CRegisterReportDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
/* ColorKey  */
	ModifyStyleEx ( 0 , WS_EX_LAYERED );
//	TRACE ( "%d %d\n" , GetLastError() , GetWindowLong ( GetSafeHwnd() , GWL_EXSTYLE ) );
	HMODULE h_user32_dll = GetModuleHandle("USER32.DLL"); 
    if(h_user32_dll != NULL){ 
		BOOL (WINAPI *fp_set_layered_window_attributes)(HWND, COLORREF, BYTE, DWORD) = 
			(BOOL (WINAPI *)(HWND, COLORREF, BYTE, DWORD))GetProcAddress(h_user32_dll, 
			"SetLayeredWindowAttributes"); 
		if(fp_set_layered_window_attributes != NULL){ 
			(*fp_set_layered_window_attributes)(m_hWnd, RGB(255, 0, 0), 0, LWA_COLORKEY); 
		} 
    } 

	if ( m_bFirst ) 
	{
		m_bmBackground.LoadBitmap ( IDB_REPORTREG_BACKGROUND );
		m_bFirst = FALSE; 
	}


	m_btnRegister.SetWindowPos ( NULL , 56, 128, 75, 22, NULL );
	m_btnRegister.LoadBitmaps ( IDB_REPORTREG_REG_NORMAL , IDB_REPORTREG_REG_CLICK , IDB_REPORTREG_REG_NORMAL );
	m_btnCancel.SetWindowPos ( NULL , 150, 128, 75, 22, NULL );
	m_btnCancel.LoadBitmaps ( IDB_REPORTREG_CANCLE_NORMAL , IDB_REPORTREG_CANCLE_CLICK , IDB_REPORTREG_CANCLE_NORMAL );
	m_editContent.SetWindowPos ( NULL , 19, 59, 236, 61, NULL );

	SetWindowPos(&wndTop, m_ptPosition.x, m_ptPosition.y, 272, 160, NULL);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CRegisterReportDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	CRect rect;
	GetClientRect ( &rect );
	CDC*	pDC = &dc;
	CDC*	pDrawDC;

	READY_BACKBUFFER ( GetSafeHwnd() , pDC , pDrawDC , RGB ( 255 , 0 , 0 ) );
	{
		DrawBackground ( pDrawDC );
	}
	BLIT_OPAQUE_BACKBUFFER ( pDC , pDrawDC );
}

void CRegisterReportDlg::DrawBackground ( CDC* pDC )
{
	CDC cdc;
	cdc.CreateCompatibleDC ( pDC );

	BITMAP bm;
	CBitmap* pOldBitmap = NULL;

	pOldBitmap = ( CBitmap *)cdc.SelectObject ( &m_bmBackground );
	m_bmBackground.GetBitmap( &bm );
	pDC->BitBlt ( 0 , 0 , bm.bmWidth , bm.bmHeight , &cdc , 0 , 0 , SRCCOPY );
	
	cdc.SelectObject ( pOldBitmap );
}

void CRegisterReportDlg::SetWindowPosition ( CRect rtPosition )
{
	m_ptPosition.x =  ( rtPosition.left + rtPosition.right ) / 2 - 136;
	m_ptPosition.y =  ( rtPosition.top + rtPosition.bottom ) / 2 - 80;
}


void CRegisterReportDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	if ( m_rtTitleBar.PtInRect( point ) )
	{
		WINDOWPLACEMENT WindowPlace;
		GetWindowPlacement( &WindowPlace );
		m_ptWindowPosition.x = WindowPlace.rcNormalPosition.left;
		m_ptWindowPosition.y = WindowPlace.rcNormalPosition.top; 

		m_ptWindowMove.x = point.x;
		m_ptWindowMove.y = point.y;
		m_nMouseState = MOUSE_STATE_LDOWN;
		m_pCursor = IDC_SIZEALL;
		HCURSOR hCursor = LoadCursor ( NULL , m_pCursor );
		::SetCursor ( hCursor );
		SetCapture();
	}	
	
	CDialog::OnLButtonDown(nFlags, point);
}

void CRegisterReportDlg::OnLButtonUp(UINT nFlags, CPoint point) 
{
	if ( m_nMouseState == MOUSE_STATE_LDOWN ) 
	{
		m_ptWindowPosition.x += ( point.x - m_ptWindowMove.x );
		m_ptWindowPosition.y += ( point.y - m_ptWindowMove.y );
		SetWindowPos( NULL , m_ptWindowPosition.x, m_ptWindowPosition.y, 272, 160, NULL);
		m_nMouseState = MOUSE_STATE_NULL;
		m_ptWindowMove.x = 0;
		m_ptWindowMove.y = 0;
		ReleaseCapture();
	}
	
	CDialog::OnLButtonUp(nFlags, point);
}

void CRegisterReportDlg::OnMouseMove(UINT nFlags, CPoint point) 
{
	if ( m_rtTitleBar.PtInRect( point ) )
	{
		m_pCursor = IDC_SIZEALL;
		HCURSOR hCursor = LoadCursor ( NULL , m_pCursor );
		::SetCursor ( hCursor );
	}

	if ( m_nMouseState == MOUSE_STATE_LDOWN )
	{
		if ( !( ( m_ptWindowMove.x == point.x ) && ( m_ptWindowMove.y == point.y ) ) )
		{				
			m_ptWindowPosition.x += ( point.x - m_ptWindowMove.x );
			m_ptWindowPosition.y += ( point.y - m_ptWindowMove.y );
			MoveWindow( m_ptWindowPosition.x, m_ptWindowPosition.y, 272, 160 );
		}
	}

	CDialog::OnMouseMove(nFlags, point);
}
