<?php
/**
 * Autoload
 *
 * @author kim tae il <tactful@phpkr.com>
 * @copyright Copyleft 2000-2007 PHPKR (http://www.phpkr.com)
 * @since 2007.09.28
 *
 * @filesource
 */
?>
<?php
/**
 * Autoload [Class]
 *
 * @see __autoload(), SiteException
 * 
 * @author kim tae il <tactful@phpkr.com>
 * @version 1.0.0
 * @package base
 * @subpackage core
 */
class Autoload {
	static $dirs = array();

	/**
	 * added Autoload directory
	 *
	 * @param string $dir [or array]
	 * @return void
	 */
	function add($dir) {
		if(is_array($dir)) return self::addArray($dir);

		array_push(self::$dirs, $dir);
		self::$dirs = array_unique(self::$dirs);
	}
	
	/**
	 * added Autoload directories
	 *
	 * @param array $dirs
	 * @return void
	 */
	function addArray($dirs) {
		if(!is_array($dirs)) return self::add($dir);
		
		foreach($dirs as $dir) {
			self::add($dir);
		}
	}

	/**
	 * getting Autoload directories
	 *
	 * @return string
	 */
	function getDirs() {
		return implode("\n", self::$dirs);
	}	
	
	/**
	 * execute
	 *
	 * @param string $class_name
	 * @return boolean
	 */
	function execute($class_name) {
		if (!class_exists($class_name, false)) {
		
			foreach(self::$dirs as $dir) {
				$class_file = $dir.'/'.$class_name.'.php';
				if(file_exists($class_file)) {
					$status = (@include_once($class_file));
				}
				if($status) break;
			}
			
			if(!$status) {
				throw new SiteException('file not found! ('.$class_name.'.php)', 1000001);
			}else if(!class_exists($class_name, false)) {
				throw new SiteException('class not found! in '.$class_name.'.php', 1000002);
			}
		}
		
		return true;
	}
}

/**
 * Autoload [Function]
 * 
 * @author kim tae il <tactful@phpkr.com>
 * @version 1.0.0
 * @package base
 * @subpackage core
 *
 * @param string $class_name
 */
function __autoload($class_name) {
	try {
		Autoload::execute($class_name);
	}catch(SiteException $e) {
		if(@constant('AUTOLOAD_DEBUG') == true) {
			$custom = ("
			<fieldset class='directories'>
			<legend><strong>Directories</strong></legend>
			".nl2br(Autoload::getDirs())."
			</fieldset>
			");
			
			$e->viewTrace($custom);
		}
	}
}

?>