<?php
/**
 * Site Route Dispatcher
 *
 * @author kim tae il <tactful@phpkr.com>
 * @copyright Copyleft 2000-2007 PHPKR (http://www.phpkr.com)
 * @since 2007.09.28
 *
 * @filesource
 */
?>
<?php
/**
 * SiteRouteDispatcher [Class]
 *
 * @see SiteException
 * 
 * @author kim tae il <tactful@phpkr.com>
 * @version 1.0.1
 * @package base
 * @subpackage core
 */
final class SiteRouteDispatcher {
	static $path = null;
	static $params = array();
	static $tables = array();
	static $cursor = array();

	static $currentTable = null;

	/**
	 * Setting Property
	 *
	 * @access private
	 */
	private function setProperties() {
		$parse_array = parse_url(ereg_replace('[:$|!&*()+~]','',$_SERVER['PATH_INFO']));
		self::$path = $parse_array['path'] . (!ereg('/$', $parse_array['path']) ? '/' : '');
		$params_array = explode("&", $parse_array['query']);
		foreach($params_array as $key => $val) {
			$param_array = explode("=", $val);
			self::$params[$param_array[0]] = $param_array[1];
		}
	}

	/**
	 * Routing Url & Params
	 *
	 * @access private
	 */
	private function routing() {
		if(count(self::$tables) == 0) return;
		
		if(array_key_exists(self::$path, self::$tables)) {
			self::$currentTable = self::$path;
			return;
		}
		
		foreach(self::$tables as $key => $val) {
			$tmpkeys = preg_match_all('(\:[a-zA-Z0-9]+)', $key, $regs);
			$tmpkey = str_replace($regs[0], "([a-zA-Z0-9\:\._-]+)", $key);
			if(ereg('^'.$tmpkey.'$', self::$path, $match)) {
				$i=1;
				foreach($regs[0] as $cursor) {
					self::$cursor[$cursor] = $match[$i];
					$i++;
				}

				self::$currentTable = $key;
				break;
			}
		}
	}

	/**
	 * execute callback
	 *
	 * @access private
	 */
	private function execute() {
		$callback = self::getAction(self::getCurrentTable());
		$callback[0] .= 'Controller';

		if(!defined('MVCROOT')) throw new SiteException('MVCROOT not defined.', 2000001);

		if(!class_exists('Autoload', false) AND !class_exists($callback[0], false)) {
			$collback_file = MVCROOT.'/controller/'.$callback[0].'.php';

			if(file_exists($collback_file)) {
				if(!(@require_once($collback_file)))
					throw new SiteException('controller file error : '.$callback_file, 2000005);
			}else {
				throw new SiteException('Not exists controller file : '.$callback_file, 2000002);
			}
		}

		if(method_exists($callback[0], $callback[1])) { 
			if(method_exists($callback[0], '__beforeCall')) call_user_func(array($callback[0], '__beforeCall'), $callback);

			if(!$view_instance = call_user_func_array(array($callback[0], $callback[1]), self::getCursor())) {
				throw new SiteException('execute failed : '.$callback[0].'::'.$callback[1], 2000004);
			}

			if(method_exists($callback[0], '__afterCall')) call_user_func(array($callback[0], '__afterCall'), $callback);
		}else {
			throw new SiteException('not found method : '.$callback[0].'::'.$callback[1], 2000003);
		}

		if(!is_a($view_instance, 'View'))
			throw new SiteException('Object failed! (not equal instance of View) : '.$callback[0].'::'.$callback[1], 2000006);

		return $view_instance->fetch();
	}

	/**
	 * getPath
	 *
	 * @return array
	 */
	function getPath() { return self::$path; }
	
	/**
	 * getParams
	 *
	 * @return array
	 */
	function getParams() { return self::$params; }
	
	/**
	 * getTables
	 *
	 * @return array
	 */
	function getTables() { return self::$tables; }
	
	/**
	 * getAction
	 *
	 * @param string $table
	 * @return array
	 */
	function getAction($table) { return self::$tables[$table]; }
	
	/**
	 * getCursor
	 *
	 * @return array
	 */
	function getCursor() { return count(self::$cursor) > 0 ? self::$cursor : array(); }
	
	/**
	 * getCurrentTable
	 *
	 * @return string
	 */
	function getCurrentTable() { return self::$currentTable; }

	/**
	 * addTable
	 *
	 * @param string $table
	 * @param string $controller
	 * @param string $method
	 */
	function addTable($table, $controller, $method) {
		self::$tables[$table] = array($controller, $method);	
	} 

	/**
	 * dispatch
	 *
	 */
	function dispatch() {
		self::setProperties();
		self::routing();

		if(!self::getCurrentTable()) throw new SiteException('route table not defined.', 2000004);

		print self::execute();
	}
}
?>