<?php
/**
 * View
 *
 * @author kim tae il <tactful@phpkr.com>
 * @copyright Copyleft 2000-2007 PHPKR (http://www.phpkr.com)
 * @since 2007.10.03
 * 
 * @filesource
 */
?>
<?php
/**
 * IView [Interface]
 * 
 * @author kim tae il <tactful@phpkr.com>
 * @version 1.0.0
 * @package base
 * @subpackage view
 */
interface IView {
	public function __construct();
	public static function make();
	public function fetch();
	public function display();
}

/**
 * View [Class]
 * 
 * @author kim tae il <tactful@phpkr.com>
 * @version 1.0.0
 * @package base
 * @subpackage view
 */
class View implements IView {
	private $path = null;
	private $params = array();

	private function set($path, $params=array()) {
		$this->path = $path;
		$this->params = $params;
	}

	public function __construct($path=null, $params=array()) {
		$this->set($path, $params);
	}
	
	public function fetch() {
		if(!$this->path) throw new SiteException('not defined path', 5000001);

		ob_start();
		if(is_array($this->params)) extract($this->params);

		if(!(@include_once $this->path)) {
			throw new SiteException('not exists view : '.$this->path, 5000002);
		}
		return ob_get_clean();
	}

	public function display() {
		print $this->fetch();
	}

	public static function make($path=null, $params=array()) {
		return new View($path, $params);
	}
}

?>