/**
	HandleThreadPacketSend

  Ŭ̾Ʈ û ؼ  ϳ  Ŷ ϴ  ϴ ̴.
  ð  ɸ  Ŷ   HandleThreadPacketSetMessage()  ѱ.
*/

#include "packet_send.h"

#include <queue>
using namespace std;


extern deque<PACKET> qSend;
extern MUTEX mu_send;


#ifdef _WIN32
DWORD WINAPI
#else
void *
#endif
	HandleThreadPacketSend(
#ifdef _WIN32
	LPVOID lParam
#else
	void *arg
#endif
	)
{

	NLSocket *server	= new NLSocket();
	PACKET packet;

	server->Create( AF_INET, SOCK_DGRAM, IPPROTO_UDP );

	///@ Ŷ   
	
	while ( 1 ) {
		memset( &packet, 0, PACKET_SIZE );
		if ( qSend.empty() == true ) {
			_milisleep( 100 );
			continue;
		}
		///  Ŷ ϳ  .
		{
			MutexLock( &mu_send );
			packet = qSend.front();
			qSend.pop_front();
			MutexUnlock( &mu_send );
		}

		/// Ŷ 
		/// @note    !   .
		server->SendTo( server->m_socket, &packet, PACKET_HEADER_SIZE, packet.returnaddr,
			packet.returnport );
		server->ChkErr();
		
		sockaddr_in taddr;
		taddr.sin_addr.s_addr = packet.returnaddr;
		_dbg_out("packet transmitted(to %s:%d)! ", inet_ntoa( taddr.sin_addr ), packet.returnport);
	}
}


HANDLE_THREAD RunThreadPacketSend()
{
	HANDLE_THREAD	hThread;
#ifdef _WIN32
	DWORD	thread_id;
	hThread = CreateThread(NULL, 0, HandleThreadPacketSend, NULL, 0, &thread_id);
#else
	int thread_id;
	thread_id = pthread_create( &hThread, NULL, HandleThreadPacketSend, NULL );
#endif
	return hThread;
}



