/**

	simple echo server

@compile

	g++ -o {file} {file}.cpp ../src/nlibrary.cpp -I../include

*/

#ifdef _WIN32

#include <winsock2.h>

#endif

#include <stdio.h>

#include "nlibrary.h"



int main ( int argc, char *argv[] )

{



	NLSocket *client, *server;



	server = new NLSocket();

	server->Create( PF_INET, SOCK_STREAM, IPPROTO_TCP );

	server->Bind( 12345 );

	server->Listen( 100 );

	SOCKET socket = server->Accept( );

	server->ChkErr();



	client = new NLSocket( );

	client->Attach( socket );





	char szRecv[ 1024 ];

	int nRecv, rc;



	while ( 1 ) {

		rc = client->Recv( szRecv, sizeof(szRecv) - 1, &nRecv );

		if ( rc ) {

			printf("something wrong...\n");

			break;

		}

		if ( nRecv == 0 ) {

			printf("client has closed its connection...\n");

			break;

		}

		szRecv[ nRecv ] = '\0';

		printf(" : %s", szRecv);

		client->Send( szRecv, nRecv );

	}





	client->Close();

	server->Close();





	server->Clean();



	return 0;

}



