/**

	simple multi-platform mulit-chat server using simple exclusive mutex

@note compile

	g++ -o osfsvr main.cpp ../share/src/nlibrary.cpp ../share/src/thread_library.cpp

		-I../share/include

@note	 Ÿ  ȭ Ѵ.

@todo	Ŭ̾Ʈ/ ó Ȳ  ߰   ȭ ʿϴ.

*/

#ifdef _WIN32



# if (_MSC_VER > 1000) 

#  pragma warning ( disable : 4355 4284  4231 4511 4512 4097 4786 4800 4018 4146 4244 4514 4127 4100 4663) 

#  pragma warning ( disable : 4245 4514 4660) // conversion from enum to unsigned int signed/unsigned mismatch 

#  if (_MSC_VER > 1200) 

#   pragma warning ( disable : 4521 4522) 

#  endif   

# endif



#endif







#ifdef _WIN32

#include <winsock2.h>

#else

#include <pthread.h>

#endif

#include <stdio.h>



#include "nlibrary.h"

#include "thread_library.h"



MUTEX mu_sock;







#include <set>

using namespace std;



/// Ŭ̾Ʈ   

set<NLSocket *> g_socket;





void HandleThread( NLSocket * client )

{

	NLSocket *socket;



	char szRecv[ 1024 ];

	int nRecv, rc;



	while ( 1 ) {

		rc = client->Recv( szRecv, sizeof(szRecv) - 1, &nRecv );

		if ( rc ) {

			printf("something wrong...\n");

			break;

		}

		if ( nRecv == 0 ) {

			printf("client has closed its connection...\n");

			break;

		}

		szRecv[ nRecv ] = '\0';

		printf(" : %s", szRecv);

		//client->Send( szRecv, nRecv );

		

		set<NLSocket *>::iterator i;

		// mutext

		MutexLock( &mu_sock );

		for ( i = g_socket.begin(); i != g_socket.end(); ++i )

		{

			socket = (NLSocket *) *i;

			if ( socket == NULL ) {

				continue;

			}

			socket->Send( szRecv, nRecv );

		}

		MutexUnlock( &mu_sock );



	}



	client->Close();

	// mutex

	MutexLock( &mu_sock );

	g_socket.erase( client );

	MutexUnlock( &mu_sock );



	delete client;

	client = NULL;

	

}





#ifdef _WIN32

DWORD WINAPI ThreadClient(LPVOID lParam)

{

	NLSocket *client = (NLSocket *) lParam;

	HandleThread( client );

	return 0;

}

#else

void *ThreadClient( void * arg )

{

	NLSocket *client = (NLSocket *) arg;

	HandleThread( client );

	pthread_exit(NULL);

}

#endif





int main ( int argc, char *argv[] )

{

	NLSocket *client, *server;



	///@note ؽ 

	MutexCreateNew( &mu_sock );

	server = new NLSocket();

	server->Create( PF_INET, SOCK_STREAM, IPPROTO_TCP );

	server->Bind( 12345 );

	server->Listen( 100 );

	while ( 1 ) {

		client = new NLSocket();			// @todo free  ־Ѵ.

		SOCKET socket = server->Accept( );

		if ( socket == INVALID_SOCKET )

			continue;



		client->Attach( socket );			// @todo    ־Ѵ.





#ifdef _WIN32

		DWORD	dwThreadID;

		HANDLE	hThread=NULL;

		hThread = CreateThread(NULL, 0, ThreadClient, client, 0, &dwThreadID);

#else

		int thread_id;

		pthread_t thread;



		thread_id = pthread_create( &thread, NULL, ThreadClient, (void *) client );

#endif



		// mutex

		MutexLock( &mu_sock );

		g_socket.insert( client );

		MutexUnlock( &mu_sock );

	}





	///@todo  Ŭ̾Ʈ  Ḧ ٸų  

	///@todo  û

	///@todo ؽ û





	return 0;

}





