
#include "packet_work.h"

#include <queue>
using namespace std;


extern deque<PACKET> qSend;
extern deque<PACKET> qWork;
extern deque<PACKET> qMsgTo;
extern MUTEX mu_work;
extern MUTEX mu_send;
extern MUTEX mu_msgto;


/**
	RunThreadPacketWork
@note qWork ִ Ŷ returnaddr  returnport  Ŭ̾Ʈ ּҿ Ʈ ִ.
*/
#ifdef _WIN32
DWORD WINAPI
#else
void *
#endif
	HandleThreadPacketWork(
#ifdef _WIN32
	LPVOID lParam
#else
	void *arg
#endif
	)
{

	///@ Ŷ ó  
	PACKET packet, result;
	while ( 1 ) {
		memset( &packet, 0, PACKET_SIZE );
		memset( &result, 0, PACKET_SIZE );
		// ť ó Ͱ   ϰ ٽ ˻
		if ( qWork.empty() == true ) {
			_milisleep(50);
			continue;
		}
		///@mutex
		{
			MutexLock( &mu_work );
			packet = qWork.front();
			qWork.pop_front();
			MutexUnlock( &mu_work );
		}

		///@note packet.returnaddr  4Ʈ ͳ ּҰ ִ. ƮũƮ ̹Ƿ
		/// ׳ ؼ Ŭ̾Ʈ Ѵ.
		

		///@note ۾ óѴ.
		///  ,  Ŷ ó Լ ѱ , ó Լ
		///  ּ, Ʈ, id, command  ȯؼ ȵȴ.

		switch ( packet.command ) {
		case packetcommand::HELLO		:
			result = packet;
			result.resultcode = packetrc::OK;
			_dbg_out("hello processed! ");
			break;
		case packetcommand::LOGIN		:
			result = _user_login( packet );
			_dbg_out("login processed! ");
			break;
		case packetcommand::SIGNUP		:
			result = _user_signup( packet );
			_dbg_out("signup processed! ");
			break;
		case packetcommand::PING		:
			result = _ping( packet );
			_dbg_out("ping processed!");
			break;
		case packetcommand::UNSIGN		:
			result = _user_unsign( packet );
			_dbg_out("unsign processed! ");
			break;
		case packetcommand::USERMOD		:
			result = _user_modify( packet );
			_dbg_out("usermod processed! ");
			break;
		case packetcommand::MSGTOALL	:
			result = packet;
			MutexLock( &mu_msgto );
			qMsgTo.push_back( packet );
			MutexUnlock( &mu_msgto );
			result.resultcode = packetrc::OK;
			_dbg_out("msgtoall processed! ");
			break;
		default							:
			result = packet;
			result.resultcode	= packetrc::UNKNOWN_PROTOCOL;
			_dbg_out("unknown protocol has been passed! ");
			break;
		}

		///@todo ۾ ó,   Ŷ
		/// ť ߰Ѵ.  , Ʈ Ǹ  Ϳ ־ش.		
		MutexLock( &mu_send );
		qSend.push_back( result );
		MutexUnlock( &mu_send );

	}
}



HANDLE_THREAD RunThreadPacketWork()
{
	HANDLE_THREAD	hThread;
#ifdef _WIN32
	DWORD	thread_id;
	hThread = CreateThread(NULL, 0, HandleThreadPacketWork, NULL, 0, &thread_id);
#else
	int thread_id;
	thread_id = pthread_create( &hThread, NULL, HandleThreadPacketWork, NULL );
#endif
	return hThread;
}





