#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include "stdafx.h"
#include "sqlite_library.h"


/**

@note	Ư 찡 ƴϸ Լ ÿ 0 Ѵ.
	next() Լ  Ŀ ġ     ִ ڵ  Ѵ.
@examples

	CSQLite db;
	db.connect( "tiklemoa.db" );
	db.query("SELECT key, value FROM config");
	TRACE("rows=%d\n", db.rows());
	TRACE("cols=%d\n", db.cols());

	while ( db.next() ) {
		TRACE("%s=%s\n", db.field("key"), db.field("value") );
	}
	
	int nServer	= atoi( db.result("SELECT count(*) FROM server") );
	db.close();
@ex2
	CSQLite db;
	db.connect(PATH_DB);
	CString q;
	q.Format("INSERT INTO thread (no) VALUES (%d)", _thread_no);
	db.query( (LPSTR)(LPCTSTR) q );
	db.close();
@ex3	ͺ̽ ̺ ִ ˻

	// DB 
	CSQLite db;
	db.connect( PATH_DB_MAILING );

	// ̺ ϴ üũ
	char *q;
	q = "SELECT count(*) FROM sqlite_master WHERE type='table'";
	int cnt = atoi( db.result( q ) );
	if ( cnt != 0 ) return;

	//  ʴ´ٸ 
	q = "create table mailing (idx integer primary key, mail char(64), result INTEGER, message char(255))";
	db.query( q );
	q = "CREATE TABLE thread (idx INTEGER PRIMARY KEY, no INTEGER)";
	db.query( q );
	db.query( "create unique index idx_mailing_result on mailing(result)" );
	db.query( "create unique index idx_thread_no on thread(no)" );

	db.close();
*/

CSQLite::CSQLite()
{
	_cols	= 0;
	_rows	= 0;
	_cursor = 0;
	_result = NULL;
}
CSQLite::~CSQLite()
{

	_finish();
}

void CSQLite::_finish()
{
	if ( _result ) {
		sqlite_free_table( _result );
		_result = NULL;
	}
}


/**
*/
int CSQLite::connect(const char *_path)
{
	_db = sqlite_open( _path , 0777, &_errmsg);

	if ( _db == 0 ) {
		return 1;
	}
	return 0;
}
/**
@important @note	 Լ   ش.
	,  ʿ   Լ ȣǱ  ó ؾѴ.
*/
int CSQLite::close()
{
	_finish();
	if ( _db ) {
		sqlite_close( _db );
		return 0;
	}
	else return 1;
}


/**


@param
	Է   Ʈ    ִ.
@return
	̸, SQLITE_OK
	̸ ڵ

	 ִ ̴ 4096 Ʈ  Ѵ.
		 SQLITE_QUERY_TOO_LONG  ϵȴ.


@note	ѹ   ´.
@note	 Ŭ ο ڵ ȴ.
*/
int CSQLite::query(char *format, ...)
{

	if ( _db == NULL ) return 2000;


	char q[4096];
	int status;
	va_list arglist;

	va_start(arglist, format);
	status = vsprintf(q, format, arglist);
	if(strlen(q) + 1 > sizeof(q) || status == EOF)
		return SQLITE_QUERY_TOO_LONG;
	va_end(arglist);
	

	/**
		 ʱȭ
	@note	_cursor ʱȭ  Ÿ ʱⰪ ʱȭ
	@note	   
	*/
	{
		_cols	= 0;
		_rows	= 0;
		_cursor	= 0;
		if ( _result ) {
			sqlite_free_table( _result );
			_result = NULL;
		}
	}


	/**  */
	_rc = sqlite_get_table( _db, q, &_result, &_rows, &_cols, &_errmsg );
	if ( _rc != SQLITE_OK ) {
#ifdef	_WINDOWS
		TRACE("%s\n", _errmsg);
#else
		fprintf( stderr, "%s\n", _errmsg );
#endif
		free(_errmsg);
		_errmsg = NULL;
		return _rc;
	}

	return SQLITE_OK;
}


/**
	 ù,ù Ѵ.
@note	ϵǴ   ڵ ȴ.
@return	  ų   쿡 NULL  Ѵ.
@note	   Ʈ  ڿ   Ѵ.
*/
const char *CSQLite::result(char *format, ...)
{
	if ( _db == NULL ) return NULL;

	char q[4096];
	int status;
	va_list arglist;

	va_start(arglist, format);
	status = vsprintf(q, format, arglist);
	if(strlen(q) + 1 > sizeof(q) || status == EOF)
		return NULL;
	va_end(arglist);


	if ( query( q ) ) return NULL;
	if ( rows() == 0 ) return NULL;

	return _result[1];
}




/**
	   ¿ ִ  (ȣ) Ѵ.
	0  ϹǷ Ȯ   ƴ϶,  ȣ̴.
	 ÷   ڵ尡 3̸, 3 ϵȴ.
@note	ù°  ÷ ̸̴.
	 0  ϵǸ   Ǿ  ڵ尡  츦 Ѵ.
@note	   ߸Ǿ , -1  ؾѴ.
*/
int CSQLite::rows()
{
	return _rows;
}
/**
	Į   Ѵ.
@note	rows() ʹ ޸ 1  Ѵ.
	 ϰ 3 ̸  Į 3 ִ ̴.
*/
int CSQLite::cols()
{
	return _cols;
}



/**
	_cursor  ڵ ȸ ġ  ִ.
	     _rows   ʴ 1   ش.

@return
	 ũ ġ Ѵ.
	, ó ȣǸ 1  Ѵ.
	0  ϵǸ query() Լ ȣ ʾҰų  ̻   Ѵ.
@ex
	ϳ ڵ忡   ̾Ƴ ؼ  next() Լ ȣؾѴ.
*/
int CSQLite::next()
{
	if ( _result == NULL )
		return 0;
	if ( _cursor >= _rows ) {
		return 0;
	}
	else {
		_cursor ++;
		return _cursor;
	}
}


/**
@return
	ʵ尡  쳪, Ÿ   NULL
*/
const char *CSQLite::field(const char *name)
{
	int i;

	
	/** ʵ ġ ã´ */
	for (i=0; i < _cols; i++) {
		if ( strcmp( _result[i], name ) == 0 ) break;
	}

	/** ʵ尡  ʴ  */
	if ( i == _cols ) return NULL;

	/** Ŀ  Ѿ  */
	if ( eof() ) return NULL;

	return _result[_cursor * _cols + i];
}

bool CSQLite::eof()
{
	return _cursor > _rows;
}

