/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.component.impl.rp;

import java.io.File;
import tle.framework.component.ComponentConfig;
import tle.framework.component.ComponentException;
import tle.framework.component.impl.ComponentBase;
import tle.framework.component.impl.rp.DefaultRequestProcessorMBean;
import tle.framework.component.impl.rp.DefaultResult;
import tle.framework.component.impl.rp.config.DefaultRPConfiguration;
import tle.framework.component.impl.rp.config.DefaultRPConfigurationDigester;
import tle.framework.component.impl.rp.handler.CommandHandler;
import tle.framework.component.impl.rp.handler.CommandHandlerFactory;
import tle.framework.component.impl.rp.handler.NoHandlerCommandHandler;
import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.component.spi.rp.RequestProcessor;
import tle.framework.component.spi.rp.Result;
import tle.framework.log.Logger;
import tle.framework.util.TLEConfigPathUtil;

public class DefaultRequestProcessor
extends ComponentBase
implements RequestProcessor,
DefaultRequestProcessorMBean {
    private CommandHandlerFactory handlerFactory;
    private String configFilePath;
    private DefaultRPConfiguration configuration;

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public boolean isUsingHandlerIndependentClassPath() {
        return this.configuration.isUsingIndependentClassPath();
    }

    public String[] getHandlerIndependentClassPath() {
        return this.configuration.getClassPathArray();
    }

    public void reloadHandlerClasses() {
        if (!this.configuration.isUsingIndependentClassPath()) {
            throw new UnsupportedOperationException("usingHandlerIndependentClassPath != true");
        }
        this.handlerFactory.reloadHandlerClasses(this.configuration);
    }

    public void reloadConfiguration() throws ComponentException {
        try {
            DefaultRPConfiguration newConfiguration;
            this.configuration = newConfiguration = DefaultRPConfigurationDigester.create(TLEConfigPathUtil.replace(this.configFilePath));
        }
        catch (Throwable e) {
            Logger.fatal("DefaultRequestProcessor.reloadConfiguration():Configuration File Loading Error", e);
            throw new ComponentException(e.getMessage(), e);
        }
        this.handlerFactory.init(this.configuration);
    }

    protected void initing(ComponentConfig config) throws ComponentException {
        this.configFilePath = config.getInitParameter("configFile");
        if (this.configFilePath == null) {
            this.configFilePath = System.getProperty("user.home") + File.separator + "DefaultRequestProcessor.xml";
        }
        try {
            this.configuration = DefaultRPConfigurationDigester.create(TLEConfigPathUtil.replace(this.configFilePath));
        }
        catch (Throwable e) {
            Logger.fatal("DefaultRequestProcessor.initing():Configuration File Loading Error", e);
            throw new ComponentException(e.getMessage(), e);
        }
        this.handlerFactory = new CommandHandlerFactory(this.configuration);
    }

    public Result process(RequestInfo ri) throws ComponentException {
        CommandHandler handler = this.handlerFactory.createCommandHandler(ri);
        if (handler instanceof NoHandlerCommandHandler) {
            throw new ComponentException("NO HANDLER:" + ri.getCommandID());
        }
        DefaultResult result = new DefaultResult(ri.getCommandID());
        try {
            result = handler.process(ri, result);
        }
        catch (Throwable e) {
            throw new ComponentException(e.getMessage(), e);
        }
        return result;
    }
}

