/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.jmx;

import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import tle.framework.component.Component;

public class MBeanServerWrapper {
    private static MBeanServerWrapper instance = new MBeanServerWrapper();
    private MBeanServer mbeanServer = null;
    private Map objectNameMap = new HashMap();

    public static MBeanServerWrapper getInstance() {
        return instance;
    }

    private MBeanServerWrapper() {
        this.mbeanServer = MBeanServerFactory.newMBeanServer();
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public void registComponent(Component comp) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException {
        ObjectName uniqueID = new ObjectName("TLE:type=" + comp.getClass().getName() + ",ID=" + comp.getID());
        this.mbeanServer.registerMBean(comp, uniqueID);
        this.objectNameMap.put(comp, uniqueID);
    }

    public void unregistComponent(Component comp) throws InstanceNotFoundException, MBeanRegistrationException {
        ObjectName uniqueID = (ObjectName)this.objectNameMap.get(comp);
        this.mbeanServer.unregisterMBean(uniqueID);
        this.objectNameMap.remove(comp);
    }
}

