/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.rmi.Remote;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIServer;
import javax.security.auth.Subject;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.remote.MX4JRemoteUtils;

public abstract class RMIServerImpl
implements RMIServer {
    private ClassLoader defaultClassLoader;
    private MBeanServer server;
    private Map environment;
    private RMIConnectorServer connector;
    private Map connections = new HashMap();
    private final AccessControlContext context;

    public RMIServerImpl(Map environment) {
        this.environment = new HashMap(environment);
        this.context = AccessController.getContext();
    }

    AccessControlContext getContext() {
        return this.context;
    }

    public abstract Remote toStub() throws IOException;

    protected abstract void export() throws IOException;

    protected abstract String getProtocol();

    protected abstract RMIConnection makeClient(String var1, Subject var2) throws IOException;

    protected abstract void closeClient(RMIConnection var1) throws IOException;

    protected abstract void closeServer() throws IOException;

    public ClassLoader getDefaultClassLoader() {
        return this.defaultClassLoader;
    }

    public void setDefaultClassLoader(ClassLoader defaultClassLoader) {
        this.defaultClassLoader = defaultClassLoader;
    }

    public synchronized void setMBeanServer(MBeanServer server) {
        this.server = server;
    }

    public synchronized MBeanServer getMBeanServer() {
        return this.server;
    }

    public String getVersion() {
        return "1.0 MX4J";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RMIConnection newClient(Object credentials) throws IOException, SecurityException {
        final Subject subject = this.authenticate(this.getEnvironment(), credentials);
        final String connectionId = MX4JRemoteUtils.createConnectionID(this.getProtocol(), null, -1, subject);
        try {
            RMIConnection client = (RMIConnection)MX4JRemoteUtils.subjectInvoke(subject, null, this.getContext(), new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return RMIServerImpl.this.makeClient(connectionId, subject);
                }
            });
            WeakReference<RMIConnection> weak = new WeakReference<RMIConnection>(client);
            Map map = this.connections;
            synchronized (map) {
                this.connections.put(connectionId, weak);
            }
            this.connector.connectionOpened(connectionId, "Opened connection " + client, null);
            return client;
        }
        catch (IOException x) {
            throw x;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new IOException(x.toString());
        }
    }

    private Subject authenticate(Map env, final Object credentials) throws SecurityException {
        Logger logger = this.getLogger();
        Subject subject = null;
        final JMXAuthenticator authenticator = (JMXAuthenticator)env.get("jmx.remote.authenticator");
        if (authenticator != null) {
            if (logger.isEnabledFor(10)) {
                logger.debug("Authenticating new client using JMXAuthenticator " + authenticator);
            }
            try {
                subject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return authenticator.authenticate(credentials);
                    }
                }, this.getContext());
                if (subject == null) {
                    throw new SecurityException("JMXAuthenticator returned null Subject");
                }
                if (logger.isEnabledFor(0)) {
                    logger.trace("Authentication successful");
                }
            }
            catch (SecurityException x) {
                if (logger.isEnabledFor(0)) {
                    logger.trace("Authentication failed", x);
                }
                throw x;
            }
            catch (Throwable x) {
                if (logger.isEnabledFor(0)) {
                    logger.trace("Authentication failed", x);
                }
                throw new SecurityException(x.toString());
            }
        }
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clientClosed(RMIConnection client) throws IOException {
        String connectionID = client.getConnectionId();
        WeakReference weak = null;
        Map map = this.connections;
        synchronized (map) {
            weak = (WeakReference)this.connections.remove(connectionID);
        }
        if (weak == null) {
            throw new IOException("Could not find active connection with ID " + connectionID);
        }
        RMIConnection connection = (RMIConnection)weak.get();
        if (connection != client) {
            throw new IOException("Could not find active connection " + client);
        }
        this.closeClient(client);
        this.connector.connectionClosed(client.getConnectionId(), "Closed connection " + client, null);
    }

    public synchronized void close() throws IOException {
        IOException serverException = null;
        try {
            this.closeServer();
        }
        catch (IOException x) {
            serverException = x;
        }
        try {
            this.closeConnections();
        }
        catch (IOException x) {
            if (serverException != null) {
                throw serverException;
            }
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void closeConnections() throws IOException {
        IOException clientException = null;
        Map map = this.connections;
        // MONITORENTER : map
        while (true) {
            if (this.connections.isEmpty()) {
                // MONITOREXIT : map
                if (clientException == null) return;
                throw clientException;
            }
            Iterator entries = this.connections.entrySet().iterator();
            Map.Entry entry = entries.next();
            WeakReference weak = (WeakReference)entry.getValue();
            RMIConnection connection = (RMIConnection)weak.get();
            if (connection == null) {
                entries.remove();
                continue;
            }
            try {
                connection.close();
            }
            catch (IOException x) {
                if (clientException != null) continue;
                clientException = x;
                continue;
            }
            break;
        }
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    Map getEnvironment() {
        return this.environment;
    }

    void setRMIConnectorServer(RMIConnectorServer cntorServer) {
        this.connector = cntorServer;
    }
}

