/*
 * $Id: memory.c,v 1.1.1.1 2002/09/19 00:37:09 halite Exp $
 */

#include <toykernel/kernel.h>
#include <toykernel/signal.h>
#include <arch/ptrace.h>

extern void die_if_kernel(char *, struct pt_regs *, long);

asmlinkage void do_page_fault(struct pt_regs *regs, unsigned long error_code)
{
	unsigned long address;

	/* get the address */
	__asm__("movl %%cr2, %0":"=r" (address));
	printk("Memory: page fault at %08lx\n", address);
	die_if_kernel("Oops", regs, error_code);
	do_exit(SIGKILL);
}

