<?

class THKFPDF extends HKFPDF
{

	function THKFPDF( $orientation = 'P', $unit = 'mm', $format = 'A4' )
	{
		$this->HKFPDF( $orientation, $unit, $format );
	}

	function Image($file,$x,$y,$w,$h=0,$type='',$link='',$ignoreMargin=false)
	{
		global $top_margin, $bottom_margin;

		//Put an image on the page
		if(!isset($this->images[$file]))
		{
			//First use of image, get info
			if($type=='')
			{
				$pos=strrpos($file,'.');
				if(!$pos)
					$this->Error('Image file has no extension and no type was specified: '.$file);
				$type=substr($file,$pos+1);
			}
			$type=strtolower($type);
			$mqr=get_magic_quotes_runtime();
			set_magic_quotes_runtime(0);
			if($type=='jpg' or $type=='jpeg')
				$info=$this->_parsejpg($file);
			elseif($type=='png')
				$info=$this->_parsepng($file);
			elseif($type=='gif')
				$info=$this->_parsegif($file);
			else
				$this->Error('Unsupported image file type: '.$type);
			set_magic_quotes_runtime($mqr);
			$info['i']=count($this->images)+1;

			$this->images[$file]=$info;
		}
		else
			$info=$this->images[$file];
		//Automatic width or height calculation
		if($w==0)
			$w=$h*$info['w']/$info['h'];
		if($h==0)
			$h=$w*$info['h']/$info['w'];


		if( $ignoreMargin == false )
		{
			/*
				̹  ̰  Ʒ    Ŭ 쿡 ׸ Ϻΰ ߷ ʵ ׸ º  Ե  ȿ  մϴ.  ̹ ҿ  ս Ͼϴ.
				*/
			if( $h > (296 - $top_margin - $bottom_margin) )
			{
				$r = (296 - $top_margin - $bottom_margin) / $h;
				$h = intval( $h * $r );
				$w = intval( $w * $r );
			}
			if( $w > (210 - $left_margin - $right_margin) )
			{
				$r = (210 - $left_margin - $rieght_margin) / $w;
				$h = intval( $h * $r );
				$w = intval( $w * $r );
			}
			/*
				 Ŀ ġ ׸ α̸    α̿ Ʒ    Ŭ 쿡 ̹  ɷ ߸ ʵ   ߰       մϴ.
				*/
			if( ($y + $h) > (296 - $bottom_margin) )
			{
				$this->addPage();
				$y = $top_margin;
			}
		}



		$this->_out(sprintf('q %.2f 0 0 %.2f %.2f %.2f cm /I%d Do Q',$w*$this->k,$h*$this->k,$x*$this->k,($this->h-($y+$h))*$this->k,$info['i']));
		if($link)
			$this->Link($x,$y,$w,$h,$link);
	}


}
?>