// testkey.cpp : ܼ  α׷   մϴ.
//
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "sdl/SDL.h"

/* Function Prototypes */
void PrintKeyInfo( SDL_KeyboardEvent *key );
void PrintModifiers( SDLMod mod );

/* main */

///D "_UNICODE" /D "UNICODE"
HINSTANCE hInst;
TCHAR szTitle[100];
TCHAR szWindowClass[100];

//  ڵ ⿡  ִ Լ  Դϴ.
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

int APIENTRY MyWinMain(HINSTANCE hInstance,
					   HINSTANCE hPrevInstance,
					   LPTSTR    lpCmdLine,
					   int       nCmdShow)
{
	MSG msg;

	//wcscpy(szWindowClass, L"myapp");
	strcpy(szWindowClass, "myapp");
	MyRegisterClass(hInstance);

	//  α׷ ʱȭ մϴ.
	if (!InitInstance (hInstance, SW_SHOW)) 
	{
		return FALSE;
	}

#if 1
	// ⺻ ޽ Դϴ.
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		
	}
#endif

	return 0;
}


ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_BYTEALIGNCLIENT|CS_OWNDC;//CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= 0;//LoadIcon(hInstance, (LPCTSTR)IDI_TEST2);
	wcex.hCursor		= 0;//LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= 0;//(LPCTSTR)IDC_TEST2;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= 0;//LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);

	return RegisterClassEx(&wcex);
}


BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND hWnd;

	hInst = hInstance; // νϽ ڵ   մϴ.

	hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
		400, 400, 200, 200, NULL, NULL, hInstance, NULL);

	if (!hWnd)
	{
		return FALSE;
	}

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	return TRUE;
}


LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	switch (message) 
	{
	case WM_CREATE:
		//ImmDisableIME(-1);
		break;
	case WM_COMMAND:
		wmId    = LOWORD(wParam); 
		wmEvent = HIWORD(wParam); 
		// ޴    мմϴ.
		return DefWindowProc(hWnd, message, wParam, lParam);
		break;
	case WM_SYSKEYUP:
	case WM_SYSKEYDOWN:
	case WM_KEYUP:
	case WM_KEYDOWN: 
		return 0;

	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);
		// TODO: ⿡ ׸ ڵ带 ߰մϴ.
		EndPaint(hWnd, &ps);
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

#undef main

int main(int argc, char *argv[])
{

	/////MyWinMain(GetModuleHandle(NULL), 0, 0, 0);
//	return 0;
	SDL_Event event;
	int quit = 0;

	//_putenv("SDL_VIDEODRIVER=directx");

	/* Initialise SDL */
	if( SDL_Init( SDL_INIT_VIDEO ) < 0){
		fprintf( stderr, "Could not initialise SDL: %s\n", SDL_GetError() );
		exit( -1 );
	}

	/* Set a video mode */
	if( !SDL_SetVideoMode( 320, 200, 0, SDL_SWSURFACE ) ){
		fprintf( stderr, "Could not set video mode: %s\n", SDL_GetError() );
		SDL_Quit();
		exit( -1 );
	}

	/* Enable Unicode translation */
	//SDL_EnableUNICODE( 1 );

	/* Loop until an SDL_QUIT event is found */
	while( !quit ){

		/* Poll for events */
		while( SDL_PollEvent( &event ) ){

			switch( event.type ){
				/* Keyboard event */
				/* Pass the event data onto PrintKeyInfo() */
					case SDL_KEYDOWN:
					case SDL_KEYUP:
						PrintKeyInfo( &event.key );
						break;

						/* SDL_QUIT event (window close) */
					case SDL_QUIT:
						quit = 1;
						break;

					default:
						
						break;
			}
			//printf("event %d\n", event.type);

		}

	}

	/* Clean up */
	SDL_Quit();
	exit( 0 );
}

/* Print all information about a key event */
void PrintKeyInfo( SDL_KeyboardEvent *key ){
	char s[3]={0,};
	/* Is it a release or a press? */
	if( key->type == SDL_KEYUP )
		printf( "Release:- " );
	else
		printf( "Press:- " );

	/* Print the hardware scancode first */
	printf( "Scancode: 0x%02X", key->keysym.scancode );
	/* Print the name of the key */
	printf( ", Name: %s", SDL_GetKeyName( key->keysym.sym ) );
	/* We want to print the unicode info, but we need to make */
	/* sure its a press event first (remember, release events */
	/* don't have unicode info                                */
	if( key->type == SDL_KEYDOWN ){

		memcpy(s, &key->keysym.unicode, 2);
		/* If the Unicode value is less than 0x80 then the    */
		/* unicode value can be used to get a printable       */
		/* representation of the key, using (char)unicode.    */
		printf(", Unicode: " );
		if( key->keysym.unicode < 0x80 && key->keysym.unicode > 0 ){
			printf( "%s (0x%04X)", s,
				key->keysym.unicode );
		}
		else{
			printf( "%s (0x%04X)", s, key->keysym.unicode);
		}
	}
	printf( "\n" );
	/* Print modifier info */
	PrintModifiers( key->keysym.mod );
}

/* Print modifier info */
void PrintModifiers( SDLMod mod ){
	printf( "Modifers: " );

	/* If there are none then say so and return */
	if( mod == KMOD_NONE ){
		printf( "None\n" );
		return;
	}

	/* Check for the presence of each SDLMod value */
	/* This looks messy, but there really isn't    */
	/* a clearer way.                              */
	if( mod & KMOD_NUM ) printf( "NUMLOCK " );
	if( mod & KMOD_CAPS ) printf( "CAPSLOCK " );
	if( mod & KMOD_LCTRL ) printf( "LCTRL " );
	if( mod & KMOD_RCTRL ) printf( "RCTRL " );
	if( mod & KMOD_RSHIFT ) printf( "RSHIFT " );
	if( mod & KMOD_LSHIFT ) printf( "LSHIFT " );
	if( mod & KMOD_RALT ) printf( "RALT " );
	if( mod & KMOD_LALT ) printf( "LALT " );
	if( mod & KMOD_CTRL ) printf( "CTRL " );
	if( mod & KMOD_SHIFT ) printf( "SHIFT " );
	if( mod & KMOD_ALT ) printf( "ALT " );
	if( mod & KMOD_IME_COMP_START) printf ("IME_COMP_START");
	if( mod & KMOD_IME_COMP) printf ("IME_COMP");
	if( mod & KMOD_IME_COMP_RESULT) printf ("IME_COMP_RESULT");
	printf( "\n" );
}
