//
// File: Button.h
// Created by: Alexander Oster - tensor@ultima-iris.de
//
/*****
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
*****/

#ifndef _BUTTON_H_
#define _BUTTON_H_

#ifdef WIN32
#include <windows.h>
#endif

#include "SDL/SDL.h"
#include "Image.h"

namespace GUI {

enum BUTTONGUMP { BUTTONGUMP_NORMAL = 0, BUTTONGUMP_MOUSEOVER, BUTTONGUMP_PRESSED };
enum BUTTONTYPE { BUTTONTYPE_BUTTON = 0, BUTTONTYPE_CHECKBOX,  BUTTONTYPE_RADIO   };

class Label;

class Button : public Control
{
public:
	Button ();
	Button (int x, int y, int w = 0, int h = 0);
	virtual ~Button ();

	void SetGump (int type, int gump);
	int GetGump (int type) const;

	void SetPressed(int pressed);
	int GetPressed(void) const;

	bool IsPageSelector(void) const;
	void SetPageSelector(bool sel);

	void SetDestinationPage(int dp);
	int GetDestinationPage(void) const;

	void SetClickMessage(gui_message * msg);
	void OnClick (int (*callback) (Control *sender));
	void DoOnClick (void);

	virtual int HandleMessage(gui_message * msg);
	virtual void Draw(GumpHandler * gumps);
	virtual bool CheckPixel(int x, int y);

	int GetReturnMsg() const { return m_return_message; }
	void SetReturnMsg(int ret_msg)  { m_return_message = ret_msg;}

	void SetCloseGump(bool cl_gump) { m_closegump = cl_gump;}
	bool isCloseGump() const { return m_closegump; }

	int  GetButtonType() const { return m_type; }
	void SetButtonType(int type);
	void SetButtonType(std::string type);

	void SetTitle(const char *text, int align, int hue, int font);
	const char *GetTitle() const;

	int GetGroupID() const { return m_groupid; }
	void SetGroupID(int groupid) { m_groupid = groupid; }

	int GetOrderID() const { return m_orderid; }
	void SetOrderID(int orderid) { m_orderid = orderid; }

	int  GetRadioIndex() const;
	void SetRadioIndex(int index);

	bool IsChecked() const { return m_checked; }
	void SetChecked(bool checked);

	void SetDirectOnClick(bool direct_onclick) { m_direct_onclick = direct_onclick; }
	bool IsDirectOnClick() const { return m_direct_onclick; }
	
protected:
	int m_button_gump[3];
	bool m_pressed;
	bool m_mouseover;
	
	bool m_isPageSelector;
	int m_destPage;
	int m_return_message;
	bool m_closegump;

	gui_message m_onclick_message;
	int (*m_callback_OnClick) (Control *sender);

	bool m_checked;
	int m_groupid;
	int m_orderid;
	int m_type;
	Label *m_label;

	bool m_direct_onclick;

	int GetCurGump() const;

	Button *GetSelectedButton();
};

}

#endif
