//
// File: Bitmask.cpp
// Created by: Alexander Oster - tensor@ultima-iris.de
//
#include "stdafx.h"
#include <iostream>
#include <math.h>
#include "renderer/Bitmask.h"
#include "include.h"
#include "Config.h"
#include <cassert>

using namespace std;

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

cBitmask::cBitmask()
{
   pixels = NULL;
}

cBitmask::~cBitmask()
{
   delete pixels;
   pixels = NULL;
}


void cBitmask::Create(Uint32 * data, int width, int height)
{
   assert(data);
   
   m_width = width;
   m_height = height;
   
   int img_mem = width * height;
   int mask_mem = (img_mem + 7) / 8;
   
   delete pixels;
   pixels = new Uint8[mask_mem];
   m_mem = mask_mem;
   
   Uint8 * dst = pixels;
   Uint32 * src = data;
   Uint32 * enddata = data + img_mem;
   
   for (int i = 0; i < mask_mem; i++) {
      Uint8 b = 0;
      for (int j = 0; j < 8; j++) {
         if (*src)
             b |= 1 << j;
         src ++;
         if (src >= enddata)
            break;
      }
      *dst = b;
      dst ++;
   }
}

bool cBitmask::CheckPixel(int x, int y, bool swapy)
{
   if ((x >= m_width) || (x < 0) || (y >= m_height) || (y < 0))
      return false;
   
   if (swapy)
      y = m_height - 1 - y;
      
   int m_pos = x + y * m_width;
   
   if ((!pixels) || (m_pos < 0))
      return false;
      
   int maskbyte = m_pos >> 3;
   int maskbit = m_pos & 7;  
   
   if (maskbyte >= m_mem)
      return false;
         
   return (pixels[maskbyte] & (1 << maskbit));
}
