#include "stdafx.h"
#include "singleinst.h"

CSingleInstance::CSingleInstance(LPCTSTR lpszMutexName)
{
	TCHAR	szBuffer[MAX_PATH] = {0};

	if(LOWORD(GetVersion()) >= 5)
		strcpy(szBuffer, "Global\\");

	strcat(szBuffer, lpszMutexName);

	m_hGlbMutex = CreateMutex(NULL, FALSE, szBuffer);
	if(GetLastError() == ERROR_ALREADY_EXISTS)
	{
		CloseHandle(m_hGlbMutex);
		m_hGlbMutex = NULL;
	}
}

CSingleInstance::~CSingleInstance()
{
	if(m_hGlbMutex)
		CloseHandle(m_hGlbMutex);
}

BOOL CSingleInstance::IsExist()
{
	return m_hGlbMutex == NULL;
}