#include "stdafx.h"
#include "imgvw_if.h"

BOOL GetProcAddresses( HINSTANCE *hLibrary, LPCSTR lpszLibrary, INT nCount, ... )
{
    BOOL bRet = TRUE;
    va_list va;
    va_start( va, nCount );
	
    if ( ( *hLibrary = LoadLibrary( lpszLibrary ) ) 
        != NULL )
    {
        FARPROC * lpfProcFunction = NULL;
        LPSTR lpszFuncName = NULL;
        INT nIdxCount = 0;
        while ( nIdxCount < nCount )
        {
            lpfProcFunction = va_arg( va, FARPROC* );
            lpszFuncName = va_arg( va, LPSTR );
            if ( ( *lpfProcFunction = 
                GetProcAddress( *hLibrary, 
				lpszFuncName ) ) == NULL )
            {
                lpfProcFunction = NULL;
                bRet = FALSE;
                break;
            }
            nIdxCount++;
        }
    }
    else
    {
		bRet = FALSE;
    }
    va_end( va );
	
	if(bRet == FALSE && *hLibrary != NULL)
		FreeLibrary(*hLibrary);
	
    return bRet;
}


CImgvwIf::CImgvwIf(HWND hwnd, int x, int y, int w, int h)
{
	m_bOk = GetProcAddresses(	&m_hInst, "imgvw.dll", 4, 
								&m_fnInitialize, "IMGVW_Initialize",
								&m_fnCleanup, "IMGVW_Cleanup",
								&m_fnCreateTrayWnd, "IMGVW_CreateTrayWnd",
								&m_fnSetBitmap, "IMGVW_SetBitmap"			);

    
	if(m_bOk)
	{
		m_fnInitialize();
		m_hTrayWnd = m_fnCreateTrayWnd(hwnd, x, y, w, h);
	}
}

CImgvwIf::~CImgvwIf()
{
	if(m_bOk)
	{
		if(m_hTrayWnd != NULL)
		{
			ShowWindow(m_hTrayWnd, SW_HIDE);
			BOOL b = DestroyWindow(m_hTrayWnd);
			DWORD dw = GetLastError();
			dw = dw;
			m_hTrayWnd = NULL;
		}

		m_fnCleanup();
		FreeLibrary(m_hInst);
	}
}

LONG CImgvwIf::SetBitmap(LPCTSTR lpszBmpName)
{
	LONG lRet = -1;

	if(IsOk())
		lRet = m_fnSetBitmap(m_hTrayWnd, lpszBmpName);

	return lRet;
}

BOOL CImgvwIf::IsOk()
{
	return m_bOk;
}

HWND CImgvwIf::GetHwnd()
{
	return m_hTrayWnd;
}