using System.Windows.Forms;
using System.Drawing;
using System;
using System.Security.Cryptography;
using System.Runtime.InteropServices;
using System.Text;

#region

// author: Dominic Ullmann, dominic_ullmann@swissonline.ch
// Version: 1.02

// VNC-Client for .NET
// Copyright (C) 2002 Dominic Ullmann

// author: Noh Seoung Hyun, gerranwizard@hotmail.com
// Version: 1.0

// VNC-Client for .NET Compact Framework
// Copyright (C) 2003 Noh Seoung Hyun

// This program is free software; 
// you can redistribute is and/or modify it under the terms of 
// the GNU General Public License as published by the Free Software Foundation;
// either version 2 of the License, or (at your option) any later version.

#endregion

namespace VNC.RFBProtocolHandling.Authenticate 
{
	/// <summary>
	/// this class implements the authentication with DES in the VNC-Protocol.
	/// </summary>
	class DESAuthenticatior 
	{
		/// <summary>
		/// this method support EncryptBytes.
		/// and this method is in "MyDESProvider.dll".
		/// MYDESPROVIDER_API void vncEncryptBytes(unsigned char *bytes, char *passwd);
		/// </summary>
		[DllImport("\\Program files\\VNCClientForPocketPC\\MyDESProvider.dll", EntryPoint = "vncEncryptBytes")]
		extern static void encryptBytes(byte[] bytes, sbyte[] password);

		/// <summary>
		/// this method encrypts the challange sent by the VNC-Server to
		/// prove the knowledge of the key
		/// </summary>
		public static byte[] encrpytChallenge(byte[] challenge, string password)
		{
			password = password + "\0";
			char[] newPassword = password.ToCharArray();
			sbyte[] ultraNewPassword = new sbyte[9];;
			for(int i = 0; i < password.Length; i++)
			{
				ultraNewPassword[i] = (sbyte)(newPassword[i]);
			}

			try
			{
				encryptBytes(challenge, ultraNewPassword);
			}
			catch(MissingMethodException)
			{
				MessageBox.Show("Error - cannot call method");
			}

			return challenge;
		}
	}

	/// <summary>
	/// this class represents a form for entering the password
	/// </summary>
	class AuthenticationForm : Form 
	{
		private Label info;
		private TextBox password;
		private Button ok;
		private Button cancel;		
		private Microsoft.WindowsCE.Forms.InputPanel inputPanel;
		private System.Windows.Forms.MainMenu mainMenu;

		public AuthenticationForm() 
		{
			FormBorderStyle = FormBorderStyle.FixedDialog;
			
			Text = "Authentication needed";
			
			info = new Label();
			info.Text = "Please provide Password";
			info.Location = new Point(10, 10);
			info.Size = new Size(200, 30);

			password = new TextBox();
			password.Text = "";
			password.ReadOnly = false;
			password.Location = new Point(10, 50);
			password.Size = new Size(200, 30);
			password.PasswordChar = '*';

			ok = new Button();
			ok.Location = new Point(10, 100);
			ok.DialogResult = DialogResult.OK;
			ok.Text = "Ok";

			cancel = new Button();
			cancel.Location = new Point(100, 100);
			cancel.DialogResult = DialogResult.Cancel;
			cancel.Text = "Abort";

			this.mainMenu = new System.Windows.Forms.MainMenu();
			this.inputPanel = new Microsoft.WindowsCE.Forms.InputPanel();
			this.Menu = this.mainMenu;

			Controls.Add(info);
			Controls.Add(password);
			Controls.Add(ok);
			Controls.Add(cancel);
		}

		public string getPassword() 
		{
			return password.Text;
		}	
	}
}