using System;
using System.Collections;

#region

// author: Dominic Ullmann, dominic_ullmann@swissonline.ch
// Version: 1.02

// VNC-Client for .NET
// Copyright (C) 2002 Dominic Ullmann

// author: Noh Seoung Hyun, gerranwizard@hotmail.com
// Version: 1.0

// VNC-Client for .NET Compact Framework
// Copyright (C) 2003 Noh Seoung Hyun

// This program is free software; 
// you can redistribute is and/or modify it under the terms of 
// the GNU General Public License as published by the Free Software Foundation;
// either version 2 of the License, or (at your option) any later version.

#endregion

namespace VNC.Config 
{
	/// <summary>
	/// this class reads in, handles and contains the configuration for the VNCClient
	/// </summary>
	public class VNCConfiguration 
	{
		/// <summary>
		/// configures nrOfViews and decoders.
		/// </summary>
		public VNCConfiguration() 
		{
			readConfig();
		}

		private int nrOfViews;
		/// <summary> the nr of views to display </summary>
		public int NrOfViews 
		{
			get { return nrOfViews; }
		}

		private ArrayList decoders = new ArrayList();
		/// <summary> the configured decoders </summary>
		public ArrayList Decoders 
		{
			get { return decoders; }
		}

		/// <summary> read in the configuration information </summary>
		private void readConfig() 
		{
			nrOfViews = 1;
		
			decoders.Add("VNC.RFBDrawing.UpdateDecoders.StandardHexitleDecoder");
			decoders.Add("VNC.RFBDrawing.UpdateDecoders.CopyRectDecoder");
			decoders.Add("VNC.RFBDrawing.UpdateDecoders.RREDecoder");
			decoders.Add("VNC.RFBDrawing.UpdateDecoders.CoRREDecoder");
			decoders.Add("VNC.RFBDrawing.UpdateDecoders.RawDecoder");
		}
	}
}