package collection;

import java.util.ArrayList;
import java.util.Iterator;

public class Tree<E> implements Iterable<E>{
	private Tree<E> root;
	private E data = null;
	private ArrayList<Tree<E>> subNodes = null;
	private Iterator<Tree<E>> it = null;
	private int depth;
	
	public int getDepth() {
		return depth;
	}

	public Tree(E data){
		if(data == null){
			System.out.println("ERROR: Tree(E data) -> data is null");
		}
		this.data = data;
		this.depth =1;
		this.root = null;
	}
	
	public Tree(E data, Tree<E> subNodes){
		if(data == null){
			System.out.println("ERROR: Tree(E data, Tree<E> subNodes) -> data is null");
		}
		if(subNodes == null){
			System.out.println("ERROR: Tree(E data, Tree<E> subNodes) -> subNodes is null");
		}
		this.data = data;
		this.subNodes = new ArrayList<Tree<E>>();
		this.subNodes.add(subNodes);
		this.depth = 1+subNodes.depth;
		this.root = null;
	}
	
	public boolean add(E data){
		if(data ==null){
			return false;
		}
		this.subNodes.add(new Tree<E>(data));
		checkDepth(1);
		return true;
	}
	
	public boolean add(Tree<E> subNodes){
		if(subNodes == null){
			return false;
		}
		if(this.subNodes == null){
			this.subNodes = new ArrayList<Tree<E>>();
		}
		this.subNodes.add(subNodes);
		checkDepth(subNodes.depth);
		subNodes.root = this;
		return true;
	}
	
	public boolean hasNextSubNodes(){
		if(subNodes == null){
			return false;
		}
		else if(it == null){
			it = new ArrayList<Tree<E>>(subNodes).iterator();
		}
		return it.hasNext();
	}
	
	public Iterator<Tree<E>> getSubNodeIterator(){
		if(subNodes == null){
			return new ArrayList<Tree<E>>().iterator();
		}
		return new ArrayList<Tree<E>>(subNodes).iterator();
	}
	
	public Tree<E> nextSubNode(){
		if(subNodes == null || it == null){
			return null;
		}
		return it.next();
	}
	
	public Iterator<E> iterator(){
		return new TreeIterator<E>(this);
	}

	public E getData() {
		return data;
	}

	public void setData(E data) {
		this.data = data;
	}
	
	private void checkDepth(int depth){
		if(this.depth < 1+depth){
			this.depth = 1+depth;
			if(root != null){
				root.checkDepth(this.depth);
			}
		}
	}
	
	public void initRound(){
		if(this.subNodes != null){
			Iterator<Tree<E>> it = new ArrayList<Tree<E>>(subNodes).iterator();
			while(it.hasNext()){
				it.next().initRound();
			}
		}
		this.it = null;
	}
}
