package collection;

import java.util.Iterator;
import java.util.Stack;

public class TreeIterator<E> implements Iterator<E> {
	Tree<E> tree;
	Stack<Tree<E>> subTreeStack;
	public TreeIterator(Tree<E> tree){
		this.subTreeStack = new Stack<Tree<E>>();
		this.tree = tree;
	}

	public boolean hasNext() {
		// TODO Auto-generated method stub
		if(this.subTreeStack.isEmpty() && this.tree == null){
			return false;
		}
		return true;
	}

	public E next() {
		// TODO Auto-generated method stub
		if(this.tree != null){
			if(this.tree.hasNextSubNodes()){
				this.subTreeStack.push(this.tree);
			}
			tree = null;
			return this.subTreeStack.peek().getData();
		}
		
		if(!this.subTreeStack.isEmpty()){
			Tree<E> tree = this.subTreeStack.peek().nextSubNode();
			if(tree.hasNextSubNodes()){
				this.subTreeStack.push(tree);
			}
			while(!this.subTreeStack.peek().hasNextSubNodes()){
				this.subTreeStack.pop();
			}
			return tree.getData();
		}
		return null;
	}

	public void remove() {
		// TODO Auto-generated method stub
		tree = null;

	}

}
