package parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Vector;

import parser.state.StartState;
import parser.state.VNProfState;
import collection.Tree;
import datatypes.CallGraphInfo;
import datatypes.FlatProfileInfo;
import exception.NoCallGraphInfoException;

public class VNProfParser {
	private Vector<FlatProfileInfo> flatInfo;
	private Tree<CallGraphInfo> callInfo;
	
	private BufferedReader inputBuffer;
	private VNProfState state;
	
	public VNProfParser(InputStream input){
		this.inputBuffer = new BufferedReader(new InputStreamReader(input));
		state = new StartState();
		
		flatInfo = new Vector<FlatProfileInfo>();
	}
	
	public void parse() throws IOException, NoCallGraphInfoException{
		Vector<Tree<CallGraphInfo>> temp = new Vector<Tree<CallGraphInfo>>();
		while(!state.isEnd()){
			state = state.nextState(inputBuffer.readLine(), flatInfo, temp);
		}
		
		Iterator<Tree<CallGraphInfo>> it = temp.iterator();
		
		if(it.hasNext()){
			callInfo = it.next();
		}
		else{
			throw new NoCallGraphInfoException();
		}
		
		while(it.hasNext()){
			Tree<CallGraphInfo> tempTree;
			if(callInfo.getDepth() < (tempTree = it.next()).getDepth()){
				callInfo = tempTree;
			}
		}
	}

	public Vector<FlatProfileInfo> getFlatInfo() {
		return flatInfo;
	}

	public Tree<CallGraphInfo> getCallInfo() {
		return callInfo;
	}
}
