package parser.state;

import java.util.Collection;

import collection.Tree;
import datatypes.CallGraphInfo;
import datatypes.FlatProfileInfo;

public class CommentState extends VNProfState {

	@Override
	protected void init(String line) {
		// TODO Auto-generated method stub
	}

	@Override
	protected VNProfState parseLine(String line) {
		// TODO Auto-generated method stub
		
		if(line == null){
			return new EndState();
		}
		
		String[] tokens = line.split("[ \t]+");
		
		if(line.trim().equals("") || tokens.length == 1){
			return this;
		}
		
		
		if(tokens[1].equalsIgnoreCase("time") && tokens[2].equalsIgnoreCase("seconds")){
			return new FlatProfileStartState();
		}
		else if(tokens[0].equalsIgnoreCase("index") && tokens[1].equalsIgnoreCase("%")){
			return new CallGraphStartState();
		}
		else{
			return this;
		}
	}

	@Override
	protected void process(Collection<FlatProfileInfo> flatProfile,
			Collection<Tree<CallGraphInfo>> callGraph) {
		// TODO Auto-generated method stub

	}

	@Override
	protected void process() {
		// TODO Auto-generated method stub
		
	}

}
