package parser.state;

import java.util.Collection;
import java.util.Iterator;

import collection.Tree;
import datatypes.CallGraphInfo;
import datatypes.FlatProfileInfo;

public class SelfState extends CallerListSuperClass {
	private Tree<CallGraphInfo> infoTree;
	private CalleeState nextState;
	private boolean nextType = false;
	
	@Override
	protected void init(String line) {
		// TODO Auto-generated method stub
		CallGraphInfo info = new CallGraphInfo();
		
		String[] tokens = line.split("[ \t]+");
		
		info.setIndex(Integer.parseInt(tokens[0].replaceAll("[^0-9]", "")));
		info.setSelf(Double.parseDouble(tokens[2]));
		info.setChildren(Double.parseDouble(tokens[3]));
		info.setName(tokens[5]);
		
		infoTree = new Tree<CallGraphInfo>(info);
	}

	@Override
	protected VNProfState parseLine(String line) {
		// TODO Auto-generated method stub

		String[] tokens = line.split("[ \t]+");
		if(!tokens[0].matches("-+")){
			nextType = true;
			nextState = new CalleeState();
			return nextState;
		}
		else {
			return new LineState();
		}
	}

	@Override
	protected void process(Collection<FlatProfileInfo> flatProfile,
			Collection<Tree<CallGraphInfo>> callGraph) {
		// TODO Auto-generated method stub
		boolean check = true;
		Iterator<Tree<CallGraphInfo>> it = callGraph.iterator();
		
		while(it.hasNext()){
			Tree<CallGraphInfo> temp;
			if((temp = it.next()).getData().getIndex() == this.infoTree.getData().getIndex()){
				check = false;
				infoTree = temp;
				break;
			}
		}
		
		if(check){
			callGraph.add(infoTree);
		}

		it = callerList.iterator();
		
		while(it.hasNext()){
			Tree<CallGraphInfo> temp = it.next();
			check = true;
			temp.initRound();
			while(temp.hasNextSubNodes()){
				Tree<CallGraphInfo> subNode = temp.nextSubNode();
				if(subNode.getData().getIndex() == this.infoTree.getData().getIndex()){
					check = false;
					break;
				}
			}
			if(check){
				temp.add(infoTree);
			}
		}

	}

	@Override
	protected void process() {
		// TODO Auto-generated method stub
		if(nextType){
			nextState.setCaller(infoTree);
		}
		
	}
}
