#include "dlist.h"

Node* init_wordnode()
{
	head = (Node*)malloc(sizeof(Node));
	tail = (Node*)malloc(sizeof(Node));

	if( head == NULL || tail == NULL)
		return NULL;

	head->prev=head;
	head->word=NULL;
	head->next=tail;

	tail->prev=head;
	tail->word=NULL;
	tail->next=tail;

	current=head;
	Wword=head;

	return current;
}

int init_findnode(char* word,int line)
{

	find_head=(Findnode*)malloc(sizeof(Findnode));
	find_tail=(Findnode*)malloc(sizeof(Findnode));

	if(find_head == NULL || find_tail == NULL)
	    return -1;

	find_head->prev=find_head;
	find_head->head=head;
	find_head->tail=tail;
	strncpy(find_head->userword,word,WORDLENGTH);
	find_head->displayline=line;
	find_head->savereadnode =0;
	find_head->next=find_tail;

	find_tail->prev=find_head;
	find_tail->head=NULL;
	find_tail->tail=NULL;
	find_tail->next=find_tail;

	current_find=find_head;

	return 0;
}

Node* get_wordnode()
{
	Node *getnode;

	getnode=(Node*)malloc(sizeof(Node));
	if(getnode == NULL)
		return NULL;
	current->next=getnode;
	getnode->prev=current;
	getnode->word=NULL;
	getnode->next=tail;
	tail->prev=getnode;
	current=getnode;

	return getnode;
}

Findnode* get_findnode(char *word)
{
    Findnode *getfindnode;

    getfindnode=(Findnode*)malloc(sizeof(Findnode));
    if(getfindnode == NULL)
	    return NULL;
    current_find->next=getfindnode;
    getfindnode->prev=current_find;
    getfindnode->head=init_wordnode();//head
    getfindnode->tail=tail;
    strncpy(getfindnode->userword,word,WORDLENGTH);
    getfindnode->displayline=find_head->displayline;
    getfindnode->savereadnode=0;
    getfindnode->next=find_tail;
    find_tail->prev=getfindnode;

    current_find=getfindnode;

    return current_find;

}

int  free_allnode()
{
        Node *tmp,*tmp1;
        Findnode *ftmp,*ftmp1;

	for(tmp=head;;tmp=tmp1)
	{
		free(tmp->word);
		tmp1=tmp->next;
		free(tmp);
		
		if( tmp == tail)
			break;

	}

	for(ftmp=find_head;;ftmp=ftmp1)
	{
		ftmp1=ftmp->next;
		free(ftmp);
		
		if( ftmp == find_tail)
			break;

	}

	return  0;
}

#if defined(MAIN_TEST)
int main(int argc, char **argv)
{
}
#endif
