#if !defined(AFX_GRAPHWND_H__6650DE88_DA91_4E17_BF8B_73A2EA5AF744__INCLUDED_)
#define AFX_GRAPHWND_H__6650DE88_DA91_4E17_BF8B_73A2EA5AF744__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// GraphWnd.h : header file
//

#include "src/win/wgnuplib.h"

/////////////////////////////////////////////////////////////////////////////
// CGraphWnd window

class CGraphWnd : public CWnd
{
// Construction
public:
	CGraphWnd();

// Attributes
public:
	GP_LPPRINT	lpr;		/* must be first */
	HINSTANCE hInstance;	/* required */
	HINSTANCE hPrevInstance;	/* required */
	LPSTR	Title;		/* required */
	int	xmax;		/* required */
	int	ymax;		/* required */
	LPTW	lptw;		/* optional */  /* associated text window */
	POINT	Origin;		/* optional */	/* origin of graph window */
	POINT	Size;		/* optional */	/* size of graph window */
	LPSTR	IniFile;	/* optional */
	LPSTR	IniSection;	/* optional */
	HWND	hWndGraph;	/* window handle */
	HWND	hParent;	/// parent window
	HMENU	hPopMenu;	/* popup menu */
	int	pen;		/* current pen number */
	int	htic;		/* horizontal size of point symbol (xmax units) */
	int 	vtic;		/* vertical size of point symbol (ymax units)*/
	int	hchar;		/* horizontal size of character (xmax units) */
	int	vchar;		/* vertical size of character (ymax units)*/
	int	angle;		/* text angle */
	BOOL	rotate;		/* can text be rotated 90 degrees ? */
	char	fontname[MAXFONTNAME];	/* font name */
	int	fontsize;	/* font size in pts */
	char	deffontname[MAXFONTNAME]; /* default font name */
	int	deffontsize;	/* default font size */
	HFONT	hfonth;		/* horizonal font */
	HFONT	hfontv;		/* rotated font (arbitrary angle) */
	LOGFONT lf;		/* cached to speed up rotated fonts */
	BOOL	resized;	/* has graph window been resized? */
	BOOL	graphtotop;	/* bring graph window to top after every plot? */
	BOOL	color;		/* color pens? */
	HPEN	hapen;		/* stored current pen */
	LOGPEN	colorpen[WGNUMPENS+2];	/* color pen definitions */
	LOGPEN	monopen[WGNUMPENS+2];	/* mono pen definitions */
	COLORREF background;		/* background color */
	HBRUSH	hbrush;		/* background brush */
	HBRUSH	colorbrush[WGNUMPENS+2];   /* brushes to fill points */
	struct GWOPBLK *gwopblk_head;
	struct GWOPBLK *gwopblk_tail;
	unsigned int nGWOP;
	BOOL	locked;		/* locked if being written */
	double  org_pointsize;	/* Original Pointsize */
// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CGraphWnd)
	//}}AFX_VIRTUAL

// Implementation
public:
	void MakePens(HDC hdc);
	virtual ~CGraphWnd();

	// Generated message map functions
protected:
	//{{AFX_MSG(CGraphWnd)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	void MakeFonts(LPRECT lprect, HDC hdc);
	void LoadCursors();
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_GRAPHWND_H__6650DE88_DA91_4E17_BF8B_73A2EA5AF744__INCLUDED_)
