/*
 * $Id: misc.h,v 1.23 2007/01/17 05:34:17 sfeam Exp $
 */

/* GNUPLOT - misc.h */

/*[
 * Copyright 1999, 2004   Thomas Williams, Colin Kelley
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the complete modified source code.  Modifications are to
 * be distributed as patches to the released version.  Permission to
 * distribute binaries produced by compiling modified sources is granted,
 * provided you
 *   1. distribute the corresponding source modifications from the
 *    released version in the form of a patch file along with the binaries,
 *   2. add special version identification to distinguish your version
 *    in addition to the base release version number,
 *   3. provide your name and address as the primary contact for the
 *    support of your modified version, and
 *   4. retain our contact information in regard to use of the base
 *    software.
 * Permission to distribute the released version of the source code along
 * with corresponding source modifications in the form of a patch file is
 * granted with same provisions 2 through 4 for binary distributions.
 *
 * This software is provided "as is" without express or implied warranty
 * to the extent permitted by applicable law.
]*/

#ifndef GNUPLOT_MISC_H
# define GNUPLOT_MISC_H

#include "syscfg.h"
#include "gp_types.h"
#include "stdfn.h"

#include "graphics.h"
#include "graph3d.h"


/* Variables of misc.c needed by other modules: */

extern char *infile_name;

/* Prototypes from file "misc.c" */

struct iso_curve * iso_alloc (int num);
void iso_extend (struct iso_curve *ip, int num);
void iso_free (struct iso_curve *ip);
void load_file (FILE *fp, char *name, TBOOLEAN subst_args);
FILE *lf_top (void);
void load_file_error (void);
FILE *loadpath_fopen (const char *, const char *);
char *fontpath_fullname (const char *);
void push_terminal (int is_interactive);
void pop_terminal (void);

/* moved here, from setshow */
enum PLOT_STYLE get_style (void);
void get_filledcurves_style_options (filledcurves_opts *);
void filledcurves_options_tofile (filledcurves_opts *, FILE *);
void lp_parse (struct lp_style_type *, TBOOLEAN, TBOOLEAN);
void lp_use_properties (struct lp_style_type *lp, int tag, int pointflag);
void arrow_parse (struct arrow_style_type *, TBOOLEAN);

void parse_fillstyle (struct fill_style_type *fs, int def_style,
                              int def_density, int def_pattern, int def_border );
void parse_colorspec (struct t_colorspec *tc, int option);

#ifdef WITH_IMAGE
void get_image_options (t_image *image);
#endif

/* State information for load_file(), to recover from errors
 * and properly handle recursive load_file calls
 */
typedef struct lf_state_struct {
    FILE *fp;			/* file pointer for load file */
    char *name;			/* name of file */
    TBOOLEAN interactive;	/* value of interactive flag on entry */
    TBOOLEAN do_load_arg_substitution;	/* likewise ... */
    int inline_num;		/* inline_num on entry */
    struct lf_state_struct *prev;			/* defines a stack */
    char *call_args[10];	/* args when file is 'call'ed instead of 'load'ed */
}  LFS;
extern LFS *lf_head;

#endif /* GNUPLOT_MISC_H */
