/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.whitebear.handler;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import net.kldp.whitebear.common.entity.DbConnectInfo;
import net.kldp.whitebear.common.entity.TableRef;
import net.kldp.whitebear.handler.JdbcHandler;
import net.kldp.whitebear.handler.QueryHandler;
import net.kldp.whitebear.handler.ui.swing.MainFrame;

public class MainHandler {
    private DefaultMutableTreeNode topTableNode;
    private DefaultMutableTreeNode topViewNode;
    private JdbcHandler jdbcHandler;
    private QueryHandler queryHandler;
    private MainFrame mainFrame;

    public MainHandler(DbConnectInfo dbConnectInfo) throws SQLException {
        this.initialize(dbConnectInfo);
    }

    private void initialize(DbConnectInfo dbConnectInfo) throws SQLException {
        this.jdbcHandler = new JdbcHandler(dbConnectInfo);
        this.queryHandler = new QueryHandler(this);
        this.topTableNode = new DefaultMutableTreeNode(dbConnectInfo.getDbName());
        this.topViewNode = new DefaultMutableTreeNode(dbConnectInfo.getDbName());
        this.makeTableTree();
        this.makeViewTree();
        this.makeUI();
    }

    private void makeUI() {
        this.mainFrame = new MainFrame();
        this.mainFrame.setMainHandler(this);
        this.getMainFrame().getCenterPanel().getBrowserPanel().getTableTreePanel().setRoot(this.getTopTableNode());
        this.getMainFrame().getCenterPanel().getBrowserPanel().getViewTreePanel().setRoot(this.getTopViewNode());
        this.getMainFrame().setVisible(true);
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    private void makeTableTree() {
        ArrayList arrayList = this.jdbcHandler.getCategory(this.jdbcHandler.getDatabaseMetaData());
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
                ArrayList arrayList2 = this.jdbcHandler.getTables(this.jdbcHandler.getDatabaseMetaData(), string);
                if (arrayList2 != null) {
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        TableRef tableRef = (TableRef)arrayList2.get(j);
                        if (!tableRef.getType().equals("TABLE")) continue;
                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(tableRef.getName()));
                    }
                }
                this.topTableNode.add(defaultMutableTreeNode);
            }
        }
    }

    private void makeViewTree() {
        ArrayList arrayList = this.jdbcHandler.getCategory(this.jdbcHandler.getDatabaseMetaData());
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
                ArrayList arrayList2 = this.jdbcHandler.getTables(this.jdbcHandler.getDatabaseMetaData(), string);
                if (arrayList2 != null) {
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        TableRef tableRef = (TableRef)arrayList2.get(j);
                        if (!tableRef.getType().equals("VIEW")) continue;
                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(tableRef.getName()));
                    }
                }
                this.topViewNode.add(defaultMutableTreeNode);
            }
        }
    }

    public void close() {
        if (this.jdbcHandler != null) {
            this.jdbcHandler.close();
            this.jdbcHandler = null;
        }
        if (this.mainFrame != null) {
            this.mainFrame.dispose();
            this.mainFrame = null;
        }
        if (this.queryHandler != null) {
            this.queryHandler.close();
            this.queryHandler = null;
        }
    }

    public QueryHandler getQueryHandler() {
        return this.queryHandler;
    }

    public JdbcHandler getJdbcHandler() {
        return this.jdbcHandler;
    }

    public DefaultMutableTreeNode getTopTableNode() {
        return this.topTableNode;
    }

    public DefaultMutableTreeNode getTopViewNode() {
        return this.topViewNode;
    }
}

