/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.whitebear.handler.ui.swing.eventhandler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import net.kldp.whitebear.common.config.SessionInfoConfig;
import net.kldp.whitebear.common.entity.DbConnectInfo;
import net.kldp.whitebear.common.log.Log;
import net.kldp.whitebear.common.variable.DBTypes;
import net.kldp.whitebear.handler.MainHandler;
import net.kldp.whitebear.handler.ui.swing.StartUpDialog;

public class StartUpEventHandler
implements ActionListener,
ListSelectionListener,
WindowListener {
    public static ArrayList mainHandlerList = null;
    private StartUpDialog startUpDialog = null;
    private SessionInfoConfig sessionInfoConfig = null;
    private int dbTypePosition = 0;
    private int dbNamePosition = 1;
    private int hostPosition = 2;
    private int portPosition = 3;
    private int userNamePosition = 4;

    public StartUpEventHandler(StartUpDialog startUpDialog) {
        this.startUpDialog = startUpDialog;
        startUpDialog.getBOk().addActionListener(this);
        startUpDialog.getBCancel().addActionListener(this);
        startUpDialog.getJTable().getSelectionModel().addListSelectionListener(this);
        startUpDialog.addWindowListener(this);
        mainHandlerList = new ArrayList();
        this.sessionInfoConfig = new SessionInfoConfig();
        this.makeSessionInfoTable();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.startUpDialog.getBOk())) {
            this.runMain();
        } else if (actionEvent.getSource().equals(this.startUpDialog.getBCancel())) {
            if (mainHandlerList.size() > 0) {
                this.startUpDialog.setVisible(false);
            } else if (mainHandlerList.size() == 0) {
                System.exit(1);
            }
        }
    }

    private void runMain() {
        block2: {
            MainHandler mainHandler = null;
            try {
                mainHandler = new MainHandler(this.startUpDialog.getDbConnectInfo());
                mainHandlerList.add(mainHandler);
                this.startUpDialog.setVisible(false);
            }
            catch (SQLException sQLException) {
                if (mainHandler == null) break block2;
                mainHandler.close();
                mainHandler = null;
            }
        }
    }

    private void makeSessionInfoTable() {
        if (this.startUpDialog.getJTable().getModel() instanceof DefaultTableModel) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.startUpDialog.getJTable().getModel();
            ArrayList arrayList = this.sessionInfoConfig.getDbConnectInfoList();
            defaultTableModel.addColumn("DB Type");
            defaultTableModel.addColumn("DB Name");
            defaultTableModel.addColumn("Host");
            defaultTableModel.addColumn("Port");
            defaultTableModel.addColumn("User Name");
            for (int i = 0; i < arrayList.size(); ++i) {
                DbConnectInfo dbConnectInfo = (DbConnectInfo)arrayList.get(i);
                Object[] objectArray = new Object[defaultTableModel.getColumnCount()];
                objectArray[this.dbTypePosition] = dbConnectInfo.getDbTypeName();
                objectArray[this.dbNamePosition] = dbConnectInfo.getDbName();
                objectArray[this.hostPosition] = dbConnectInfo.getHost();
                objectArray[this.portPosition] = dbConnectInfo.getPort();
                objectArray[this.userNamePosition] = dbConnectInfo.getUserName();
                defaultTableModel.addRow(objectArray);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int n = listSelectionModel.getMinSelectionIndex();
            JTable jTable = this.startUpDialog.getJTable();
            String string = (String)jTable.getValueAt(n, this.dbTypePosition);
            String string2 = (String)jTable.getValueAt(n, this.dbNamePosition);
            String string3 = (String)jTable.getValueAt(n, this.hostPosition);
            String string4 = (String)jTable.getValueAt(n, this.portPosition);
            String string5 = (String)jTable.getValueAt(n, this.userNamePosition);
            Log.logger.debug((Object)("dbTypeName : " + string));
            Log.logger.debug((Object)("dbName     : " + string2));
            Log.logger.debug((Object)("host       : " + string3));
            Log.logger.debug((Object)("port       : " + string4));
            Log.logger.debug((Object)("userName   : " + string5));
            DbConnectInfo dbConnectInfo = new DbConnectInfo();
            dbConnectInfo.setDbName(string2);
            dbConnectInfo.setHost(string3);
            dbConnectInfo.setPort(string4);
            dbConnectInfo.setUserName(string5);
            dbConnectInfo.setDbtype(DBTypes.getDbType(string));
            this.startUpDialog.setDbConnectInfo(dbConnectInfo);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (mainHandlerList.size() > 0) {
            this.startUpDialog.setVisible(false);
        } else if (mainHandlerList.size() == 0) {
            System.exit(1);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

