import sys
import os
import time

from SendPacket import *
from SockThread import *

sys.path.insert(0,'./bot')
from empasDic import *
from googleNews import *
from lotto import *
from kwBoard import *
from yahooWeather import *

# Switch Board
class SBThread(SockThread):
	
	def __init__(self, userid, passwd, svrCmd):
				
		self.userid = userid		#  
		self.passwd = passwd
		self.sessionId = svrCmd[1]		#  ID
		addrInfo = svrCmd[2].split(':')
		self.addr = addrInfo[0]			#  IP
		self.port = int(addrInfo[1])	#  PORT

		self.curMode = 'default'		#  带 Ÿ(  )

		self.notifyCode = svrCmd[4]		# ڵ
		self.callUser = svrCmd[5]		# ȭ û ģ 

		self.logfile = ''				# ȭ  ϴ 
		self.textLog = ''			# ȭ   δ 

		self.objectname = 'SB'
		
		SockThread.__init__(self, self.userid, self.passwd)		# SB  
		
		self.auth_SB()		# äü 
		self.packet_ANS()		# ANS 


		self.process_SB()		# ȭ μ


	def auth_SB(self):
		self.makeConnect(serverinfo = (self.addr,self.port))
		print ' äü  Ǿϴ.'
		
	#   ̵ ִ ޽
	def returnID(self):
		return self.sessionId

	#  ANS 
	def packet_ANS(self):
		packet = SendPacket('ANS')
		trid = self.getTrid()
		packet.add(trid)
		packet.add(self.userid)
		packet.add(self.notifyCode)
		packet.add(self.sessionId)
		self.send(packet)

	# ȭ μ
	def process_SB(self):

		while 1:
			self.objectname = 'SB' + str(self.sessionId)	
			recvStr = self.recvCmd()
			try:

				if(recvStr[0] == 'MSG'):

					if(recvStr[7] == 'text/x-msmsgscontrol'):		#  ȭâ ų Էϰ  
						print '----' * 15
						print self.callUser + '  Էϰ ֽϴ.'

					else:			# ޽ ޾  Ѵ.
						self.msgControl()			# WIT  Է̶ ޽ .

						recvMsgTemp = self.getRecvMsg(recvStr)		# Ź ޽  ϰ  ޽ 
						recvMsg = recvMsgTemp
						#---------------------------------------------------------------------------------------------
		
						#  û
						if recvMsg[:1] == '!':
							dic = empasDic()
							sendMsg = dic.searchDic(recvMsg[1:])
						#---------------------------------------------------------------------------------------------
						#  û
						elif recvMsg[:4] == '':
							sendMsg = '-----' * 15 + '\r\n'
							sendMsg += ' ˾ƺ  ȣ Էϼ.(⺻ /)\r\n'
							sendMsg += '-----' * 15 + '\r\n'
							sendMsg += '1./ 2.泲 3. 4. 5. 6.\r\n'
							sendMsg += '7. 8.︪/ 9.泲 10. 11.\r\n'
							sendMsg += '-----' * 15 + '\r\n'
							self.curMode = 'Weather'
						#---------------------------------------------------------------------------------------------

						# 忡   
						elif self.curMode == 'Weather':	
							sendMsg = self.weatherProc(recvMsg[:1])
							self.curMode = 'default'			#   ȯ
						#---------------------------------------------------------------------------------------------

						elif recvMsg[:4] == '':
							news = googleNews()
							sendMsg = news.viewNews()
						#---------------------------------------------------------------------------------------------
						
						elif recvMsg[:4] == 'ζ':
							lotto = Lotto()
							sendMsg = lotto.viewLotto()
						#---------------------------------------------------------------------------------------------
						
						elif recvMsg[:6] == '':
							kw = kwBoard()
							sendMsg = kw.viewBoard()
						#---------------------------------------------------------------------------------------------

						else:
							sendMsg = ''
						#---------------------------------------------------------------------------------------------

						self.msgSend(sendMsg)		# ޽ 

				elif(recvStr[0] == 'BYE'):
					print '----' * 15
					print self.callUser + '  ȭ ϴ.  ŵϴ.'

					logname = './log/' + self.callUser + '.log'
					try:
						fd = open(logname, 'a+')
						fd.write(self.textLog)
						fd.close()
					except:
						print '  κп  ߻߽ϴ.'

					self.sock.closeSock()
					break
				
				elif(recvStr[0] == 'ACK'):
					print '----' * 15
					print '޽ ùٸ ۵Ǿϴ.'
				
				elif(recvStr[0] == 'IRO'):
					print 'IRO  ޾ҽϴ'
					pass

				elif(recvStr[0] == 'ANS'):
					print 'ANS  ޾ҽϴ.'
					pass

				else:
					print '----' * 15
					print '    ߽ϴ.'
					pass

			except:
				print 'SBThread   ó ߽ϴ.'
				break

	#    ִ ޽
	def weatherProc(self, recvMsg):
		weather = yahooWeather()

		if recvMsg == '1':
			recvWeather = weather.getWeather('1')
		elif recvMsg == '2':
			recvWeather = weather.getWeather('2')
		elif recvMsg == '3':
			recvWeather = weather.getWeather('3')
		elif recvMsg == '4':
			recvWeather = weather.getWeather('4')
		elif recvMsg == '5':
			recvWeather = weather.getWeather('5')
		elif recvMsg == '6':
			recvWeather = weather.getWeather('6')
		elif recvMsg == '7':
			recvWeather = weather.getWeather('7')
		elif recvMsg == '8':
			recvWeather = weather.getWeather('8')
		elif recvMsg == '9':
			recvWeather = weather.getWeather('9')
		elif recvMsg == '10':
			recvWeather = weather.getWeather('10')
		elif recvMsg == '11':
			recvWeather = weather.getWeather('11')
		else:
			recvWeather = weather.getWeather('1')

		return recvWeather

	#  Էϰ ִٴ ޽  ޽
	def msgControl(self):
		#  Էϰ ִٴ ޽ 
		preMsging = 'MIME-Version: 1.0\r\n'
		preMsging += 'Content-Type: text/x-msmsgscontrol\r\n'
		preMsging += 'TypingUser: ' + self.userid + '\r\n\r\n'

		#   Ŷ 
		packet = SendPacket('MSG')
		trid = self.getTrid()
		packet.add(trid)
		packet.add('U')
		packet.add(str(len(preMsging))+'\r\n' + preMsging)
		print self.objectname + '[SEND:' + str(self.sock.fileno()) + '] ' + preMsging
		buf = packet.toSend()
		self.sock.send(buf)

	#  ޽ ϴ ޽
	def msgSend(self, sendMsg):

		#  ޽ñ  ⺻ ޽  
		if(sendMsg == ''):
			sendMsg = '-----' * 15 + '\r\n'
			sendMsg += '[ȳϼ! ƮԴϴ.] - http://sadrove.com/wit/\r\n'
			sendMsg += '-----' * 15 + '\r\n'
			sendMsg += '## /ѻ  \r\n'
			sendMsg += '    ex) !school\r\n'
			sendMsg += '    ex) !б\r\n'
			sendMsg += '## 밡 ɾ : '
			sendMsg += ' / ζ /  / \r\n'
			sendMsg += '-----' * 15 + '\r\n'
	
		# ޽  
		sendMsging = 'MIME-Version: 1.0\r\n'
		sendMsging += 'Content-Type: text/plain; charset=UTF-8\r\n'
		sendMsging += 'X-MMS-IM-Format: FN=Arial; EF=; CO=f85c30; CS=81; PF=22\r\n\r\n'

		self.textLog += time.strftime('%Y/%m/%d %H:%M:%S', time.localtime(time.time()+16*60*60)) + ' [Ʈ] ' + '\r\n' + sendMsg + '\r\n\r\n'				# ޽ 

		sendMsging += sendMsg				# ޽  ħ
		sendMsgingTemp = sendMsging
		
		try:
			sendMsging = unicode(sendMsgingTemp, 'cp949').encode('utf-8')
		except:
			sendMsging = sendMsgingTemp

		#   Ŷ 
		packet = SendPacket('MSG')
		trid = self.getTrid()
		packet.add(trid)
		packet.add('N')
		packet.add(str(len(sendMsging))+'\r\n' + sendMsging)
		print self.objectname + '[SEND:' + str(self.sock.fileno()) + '] ' + sendMsging
		buf = packet.toSend()
		self.sock.send(buf)

	# Ź ޽   Ͽ  ޽ ϴ ޽
	def getRecvMsg(self, recvStr):
		#  
		recvMsg = ''
		for i in recvStr:
			recvMsg += i + ' '
		msgFind = recvMsg.find('PF=')
		recvMsg = recvMsg[msgFind:]
		msgFind = recvMsg.find(' ')
		recvMsg = recvMsg[msgFind+1:]				# ģ Է  ޽ 
		recvMsgTemp = recvMsg
		
		self.textLog += time.strftime('%Y/%m/%d %H:%M:%S', time.localtime(time.time()+16*60*60)) + ' [' + self.callUser + '] ' + '\r\n' + recvMsg + '\r\n\r\n'				# ޽ 
		
		return recvMsg

