#!/usr/bin/env python
from wxPython.wx import *
from wxk_panelmain import wxKPanelMain
#-------------------------------------------------------------------------------
class wxKFrameMain(wxFrame):
    # ϸ޴
    ID_MENU_FILE_NEW        = 5103
    ID_MENU_FILE_OPEN       = 5104
    ID_MENU_FILE_CLOSE      = 5105
    ID_MENU_FILE_CLOSEALL   = 5106
    ID_MENU_FILE_QUIT       = 5107
    # ޴
    ID_MENU_EDIT_UNDO       = 5201
    ID_MENU_EDIT_REDO       = 5202
    ID_MENU_EDIT_CUT        = 5203
    ID_MENU_EDIT_COPY       = 5204
    ID_MENU_EDIT_PASTE      = 5205
    # ã޴
    ID_MENU_FIND_FIND       = 5301
    ID_MENU_FIND_NEXT       = 5302
    ID_MENU_FIND_PREV       = 5303
    ID_MENU_FIND_NEXT       = 5304
    ID_MENU_FIND_REPLACE    = 5305
    ID_MENU_FIND_FINDINFILES    = 5306
    ID_MENU_FIND_REPLACEINFILES = 5307
    # â޴
    ID_MENU_WIN_UNSPLIT     = 5401
    ID_MENU_WIN_HSPLIT     = 5402
    ID_MENU_WIN_VSPLIT     = 5403
    # 򸻸޴
    ID_MENU_HELP_ABOUT      = 5808
    #---------------------------------------------------------------------------
    def __init__(self, parent, ID, title, pos, size, style):
        wxFrame.__init__(self, parent, ID, title, pos, size, style)

        self.InitMenu()
        self.InitStatusBar()
        self.InitWindow()
        EVT_SIZE(self, self.OnSize)
    #---------------------------------------------------------------------------
    def InitMenu(self):
        #ϸ޴
        MenuFile= wxMenu()
        MenuFile.Append(self.ID_MENU_FILE_NEW,     " \tCtrl+N",  "  ")
        MenuFile.Append(self.ID_MENU_FILE_OPEN,    "\tCtrl+O",     " ")
        MenuFile.Append(self.ID_MENU_FILE_CLOSE,   "ݱ\tCtrl+F4",    " ")
        MenuFile.Append(self.ID_MENU_FILE_CLOSEALL,"δݱ",         "  ")
        MenuFile.AppendSeparator()
        MenuFile.Append(self.ID_MENU_FILE_QUIT,    "\tAlt+X",    "wxK ")
        #޴
        MenuEdit= wxMenu()
        MenuEdit.Append(self.ID_MENU_EDIT_UNDO,     "ǵ\tCtrl+Z", " · ǵ")
        MenuEdit.Append(self.ID_MENU_EDIT_REDO,     "ٽϱ",         " · ǵ")
        MenuEdit.AppendSeparator()
        MenuEdit.Append(self.ID_MENU_EDIT_CUT,      "߶󳻱\tCtrl+X", " ߶")
        MenuEdit.Append(self.ID_MENU_EDIT_COPY,     "ϱ\tCtrl+C", " ")
        MenuEdit.Append(self.ID_MENU_EDIT_PASTE,    "ٿֱ\tCtrl+V", " ٿ")
        #ã޴
        MenuFind= wxMenu()
        MenuFind.Append(self.ID_MENU_FIND_FIND,     "ã\tCtrl+F",     "")
        MenuFind.Append(self.ID_MENU_FIND_NEXT,     "ã\tF3",     "")
        MenuFind.Append(self.ID_MENU_FIND_PREV,     "ã\tShift+F3",    "")
        MenuFind.Append(self.ID_MENU_FIND_REPLACE,  "ٲٱ\tCtrl+R",   "")
        MenuFind.AppendSeparator()
        MenuFind.Append(self.ID_MENU_FIND_FINDINFILES,      "Ͽ ã\tCtrl+Shift+F",  "")
        MenuFind.Append(self.ID_MENU_FIND_REPLACEINFILES,   "Ͽ ٲٱ\tCtrl+Shift+R","")
        #â޴
        MenuWin = wxMenu()
        MenuWin.Append(self.ID_MENU_WIN_UNSPLIT, "ġ")
        MenuWin.Append(self.ID_MENU_WIN_HSPLIT, "򳪴")
        MenuWin.Append(self.ID_MENU_WIN_VSPLIT, "")
        #򸻸޴
        MenuHelp = wxMenu()
        MenuHelp.Append(self.ID_MENU_HELP_ABOUT, "wxK\tF1")
        #޴
        MenuBar = wxMenuBar()
        MenuBar.Append(MenuFile, "&F)")
        MenuBar.Append(MenuEdit, "&E)")
        MenuBar.Append(MenuFind, "&S)ã")
        MenuBar.Append(MenuWin,  "&W)â")
        MenuBar.Append(MenuHelp, "&H)")

        self.SetMenuBar(MenuBar)

        EVT_MENU(self, self.ID_MENU_FILE_OPEN, self.OnMenuFileOpen)
    #---------------------------------------------------------------------------
    def InitStatusBar(self):
        self.CreateStatusBar()
    #---------------------------------------------------------------------------
    def InitWindow(self):
        PanelToolBarHeight=55
        self.SetAutoLayout(true)
        self.m_PanelToolBar=wxPanel(self, -1, wxDefaultPosition, wxDefaultSize, style=wxNO_3D | wxNO_BORDER )
        lc = wxLayoutConstraints()
        lc.top.SameAs(self, wxTop, 0)
        lc.left.SameAs(self, wxLeft, 0)
        lc.right.SameAs(self, wxRight, 0)
        lc.bottom.SameAs(self, wxTop, -PanelToolBarHeight)
        self.m_PanelToolBar.SetConstraints(lc)

        self.m_NoteBookToolBar=wxNotebook(self.m_PanelToolBar, -1, wxDefaultPosition, wxDefaultSize, wxNO_3D | wxSIMPLE_BORDER )
        lc = wxLayoutConstraints()
        lc.top.SameAs(self.m_PanelToolBar, wxTop, 0)
        lc.left.SameAs(self.m_PanelToolBar, wxLeft, 0)
        lc.right.SameAs(self.m_PanelToolBar, wxRight, 0)
        lc.bottom.SameAs(self.m_PanelToolBar, wxBottom, 0)
        self.m_NoteBookToolBar.SetConstraints(lc)

        self.m_ToolBar6 = wxToolBar(self.m_NoteBookToolBar, -1,  wxDefaultPosition, wxDefaultSize, wxTB_HORIZONTAL|wxTB_FLAT|wxNO_BORDER )
        self.m_ToolBar6.AddSimpleTool(10, wxBitmap("new.bmp", wxBITMAP_TYPE_BMP), "New", "Long help for 'New'")
        self.m_ToolBar6.AddSimpleTool(20, wxBitmap("open.bmp", wxBITMAP_TYPE_BMP), "Open", "Long help for 'Open'")
        self.m_ToolBar6.Realize()
        self.m_NoteBookToolBar.AddPage(self.m_ToolBar6, "ToolBar")

        self.m_PanelMain=wxKPanelMain(self, -1, wxDefaultPosition, wxDefaultSize, style=wxNO_3D | wxNO_BORDER )
        lc = wxLayoutConstraints()
        lc.top.SameAs(self, wxTop, PanelToolBarHeight)
        lc.left.SameAs(self, wxLeft, 0)
        lc.right.SameAs(self, wxRight, 0)
        lc.bottom.SameAs(self, wxBottom, 0)
        self.m_PanelMain.SetConstraints(lc)
    #---------------------------------------------------------------------------
    def OnSize(self, event):
        self.Layout()
    #---------------------------------------------------------------------------
    def OnMenuFileOpen(self, event):
        wxFileSelector('')
#-------------------------------------------------------------------------------
