﻿/*
 *  X-IRC Server
 *   Copyright (C) 2004-2009 Paradoxoft Corporation.
 *   Copyright (C) 2009 Stephanos San Io.
 *  
 *  < GNU GPL v3 Terms >
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace Server.Core
{
    class DatabaseException : Exception
    {
        public DatabaseException()
            : base("Objekt invalid.")
        { }
    }

    abstract class Database
    {
        protected Dictionary<string, object> _LoadedInformation;

        public abstract bool Load();
        public abstract bool Save();

        public abstract object Get(string Name);
        public abstract bool Set(string Name, object Value);
    }

    class Database_File : Database
    {
        public Database_File()
        {
            _LoadedInformation = new Dictionary<string, object>();
        }

        public override bool Load()
        {
            try
            {
                string[] FileData = File.ReadAllLines(System.Windows.Forms.Application.StartupPath + "\\Crap.db", Encoding.Unicode);
                for (int i = 0; i < FileData.Length; i++)
                {
                    string CurrentLine = FileData[i].Trim(' ', '\t');
                    if (string.IsNullOrEmpty(CurrentLine))
                        continue;
                    if (CurrentLine[0] == '#')
                        continue;
                    string[] SplitByTab = CurrentLine.Split(new char[] { '\t' }, StringSplitOptions.RemoveEmptyEntries);
                    string FieldName = SplitByTab[0];
                    object FieldValue = SplitByTab[1].Replace("\\n", "\n").Replace("\\t", "\t").Replace("\\002", "\002");
                    switch (FieldName.ToLower()) // Fields that need specific value processing.
                    {
                        case "provider_defaultencoding":
                            FieldValue = Encoding.GetEncoding((string)FieldValue);
                            break;
                        case "provider_endpoints":
                            string[] EndPoints = ((string)FieldValue).Split(',');
                            FieldValue = new System.Net.IPEndPoint[EndPoints.Length];
                            for (int j = 0; j < EndPoints.Length; j++)
                            {
                                string[] EndPointSep = EndPoints[j].Split(':');
                                ((System.Net.IPEndPoint[])FieldValue)[j] = new System.Net.IPEndPoint(System.Net.IPAddress.Parse(EndPointSep[0]), Convert.ToInt32(EndPointSep[1]));
                            }
                            break;
                        case "message_0102":
                        case "message_1002":
                            FieldValue = ((string)FieldValue).Split('\n');
                            break;
                    }
                    _LoadedInformation.Add(FieldName, FieldValue);
                }
                return true;
            }
            catch
            {
                return false;
            }
        }

        public override bool Save()
        {
            throw new NotImplementedException();
        }

        public override object Get(string Name)
        {
            try
            {
                return _LoadedInformation[Name];
            }
            catch
            {
                throw new DatabaseException();
            }
        }

        public override bool Set(string Name, object Value)
        {
            try
            {
                if (_LoadedInformation.ContainsKey(Name) == true)
                    _LoadedInformation[Name] = Value;
                else
                    _LoadedInformation.Add(Name, Value);
                return true;
            }
            catch
            {
                throw new DatabaseException();
            }
        }
    }
}