﻿/*
 *  X-IRC Server
 *   Copyright (C) 2004-2009 Paradoxoft Corporation.
 *   Copyright (C) 2009 Stephanos San Io.
 *  
 *  < GNU GPL v3 Terms >
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

using System;
using System.Collections.Generic;

namespace Server.Provider
{
    class ChannelManager
    {
        private SortedList<int, Channel> _ChannelList;
        private int _NextChannelId;

        public int ChannelCount
        {
            get
            {
                return _ChannelList.Count;
            }
        }

        public Channel this[int Id]
        {
            get
            {
                return _ChannelList[Id];
            }
        }

        public Channel this[string ChannelName]
        {
            get
            {
                for (int i = 0; i < _ChannelList.Count; i++)
                {
                    if (_ChannelList.Values[i].Name == ChannelName)
                        return _ChannelList.Values[i];
                }
                return null;
            }
        }

        public ChannelManager()
        {
            _ChannelList = new SortedList<int, Channel>();
            _NextChannelId = 0;
        }

        public bool Add(Channel TargetChannel)
        {
            try
            {
                _ChannelList.Add(_NextChannelId, TargetChannel);
                _NextChannelId++;
                return true;
            }
            catch
            {
                return false;
            }
        }

        public void Remove(int Id)
        {
            try
            {
                _ChannelList.Remove(Id);
            }
            catch { }
        }
    }
}