﻿/*
 *  X-IRC Server
 *   Copyright (C) 2004-2009 Paradoxoft Corporation.
 *   Copyright (C) 2009 Stephanos San Io.
 *  
 *  < GNU GPL v3 Terms >
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

using System;
using System.Net;
using System.Net.Sockets;
using System.Collections.Generic;

namespace Server.Provider
{
    class ConnexionManager
    {
        private Socket[] _AcceptorSocket;

        private SortedList<long, Connexion> _ConnexionList;
        private long _NextConnexionId;

        public long ConnexionsCount
        {
            get
            {
                return _ConnexionList.Count;
            }
        }

        public Connexion this[int Id]
        {
            get
            {
                return _ConnexionList[Id];
            }
        }

        public Connexion this[string Nickname]
        {
            get
            {
                for (int i = 0; i < _ConnexionList.Count; i++)
                {
                    if (_ConnexionList.Values[i].Mode > 0)
                    {
                        if (_ConnexionList.Values[i].Nickname == Nickname)
                            return _ConnexionList.Values[i];
                    }
                }
                return null;
            }
        }

        public ConnexionManager()
        {
            // Acceptor Socket
            _AcceptorSocket = new Socket[((IPEndPoint[])Program.XDatabase.Get("Provider_EndPoints")).Length];
            for (int i = 0; i < ((IPEndPoint[])Program.XDatabase.Get("Provider_EndPoints")).Length; i++)
            {
                _AcceptorSocket[i] = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
                _AcceptorSocket[i].Bind(((IPEndPoint[])Program.XDatabase.Get("Provider_EndPoints"))[i]);
            }
            // Connexion Management
            _ConnexionList = new SortedList<long, Connexion>(Convert.ToInt32(Program.XDatabase.Get("Provider_MaximumConnexions")));
            _NextConnexionId = 0;
        }

        public bool StartAcception()
        {
            try
            {
                for (int i = 0; i < ((IPEndPoint[])Program.XDatabase.Get("Provider_EndPoints")).Length; i++)
                {
                    _AcceptorSocket[i].Listen(Convert.ToInt32(Program.XDatabase.Get("Provider_Backlogs")));
                    _AcceptorSocket[i].BeginAccept(new AsyncCallback(AcceptCallbackProcedure), i);
                }
                return true;
            }
            catch
            {
                return false;
            }
        }

        public void StopAcception()
        {
            try
            {
                for (int i = 0; i < ((IPEndPoint[])Program.XDatabase.Get("Provider_EndPoints")).Length; i++)
                {
                    _AcceptorSocket[i].Close();
                    _AcceptorSocket[i] = null;
                }
            }
            catch { }
        }

        public bool _DeleteConnexionFromList(long Id)
        {
            try
            {
                return _ConnexionList.Remove(Id);
            }
            catch
            {
                return false;
            }
        }

        public bool _ContainsKey(long Id)
        {
            return _ConnexionList.ContainsKey(Id);
        }

        private void AcceptCallbackProcedure(IAsyncResult Result)
        {
            try
            {
                Socket TransmissionSocket = _AcceptorSocket[(int)Result.AsyncState].EndAccept(Result);
                _ConnexionList.Add(_NextConnexionId, new Connexion(_NextConnexionId, TransmissionSocket));
                _NextConnexionId++;
                _AcceptorSocket[(int)Result.AsyncState].BeginAccept(new AsyncCallback(AcceptCallbackProcedure), Result.AsyncState);
            }
            catch
            {
                StopAcception();
                StartAcception();
            }
        }
    }
}