﻿/*
 *  X-IRC Server
 *   Copyright (C) 2004-2009 Paradoxoft Corporation.
 *   Copyright (C) 2009 Stephanos San Io.
 *  
 *  < GNU GPL v3 Terms >
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

using System;
using System.Threading;

namespace Server.Provider
{
    class Monitor
    {
        private Thread _WorkerThread1;
        private Thread _WorkerThread2;

        public Monitor()
        {
            _WorkerThread1 = new Thread(new ThreadStart(WorkerThread1Procedure));
            _WorkerThread1.Start();
            _WorkerThread2 = new Thread(new ThreadStart(WorkerThread2Procedure));
            _WorkerThread2.Start();
        }

        private void WorkerThread2Procedure()
        {
            ReEnter:
            try
            {
                while (true)
                {
                    // Channel and User Consistency Check (for the situation where the client was errornously disconnected from the server and was not removed from the channel connexion list.)
                    for (int i = 0; i < Program.XChannelManager.ChannelCount; i++)
                    {
                        for (int j = 0; j < Program.XChannelManager[i].ConnexionList.Count; j++)
                        {
                            if (Program.XConnexionManager._ContainsKey(Program.XChannelManager[i].ConnexionList[j].Id) == false)
                                Program.XChannelManager[i].ConnexionLeave(Program.XChannelManager[i].ConnexionList[j].Id);
                        }
                    }
                    Thread.Sleep(15000);
                }
            }
            catch
            {
                goto ReEnter;
            }
        }

        private void WorkerThread1Procedure()
        {
            ReEnter:
            try
            {
                while (true)
                {
                    for (int i = 0; i < Program.XConnexionManager.ConnexionsCount; i++)
                    {
                        // Received Packets
                        if (Program.XConnexionManager[i].ReceivedPacketsCountInSecond > Convert.ToInt32(Program.XDatabase.Get("Provider_MaximumReceivedPacketsPerSecond")))
                            Program.XConnexionManager[i].Disconnect();
                        Program.XConnexionManager[i].ReceivedPacketsCountInSecond = 0;
                        // Received Bytes
                        if (Program.XConnexionManager[i].ReceivedBytesInSecond > Convert.ToInt32(Program.XDatabase.Get("Provider_MaximumReceivedBytesPerSecond")))
                            Program.XConnexionManager[i].Disconnect();
                        Program.XConnexionManager[i].ReceivedBytesInSecond = 0;
                        // Disconnection Check
                        if (Program.XConnexionManager[i].DisconnectionFlag == true)
                        {
                            if (Program.XConnexionManager[i].DisconnectionTime < DateTime.Now)
                                Program.XConnexionManager[i].Disconnect();
                        }
                    }
                    Thread.Sleep(1000);
                }
            }
            catch
            {
                goto ReEnter;
            }
        }
    }
}