/*
 * Decompiled with CFR 0.152.
 */
package cookxml.common.creator;

import cookxml.core.CookXml;
import cookxml.core.DecodeEngine;
import cookxml.core.creator.Creator;
import cookxml.core.exception.CookXmlException;
import cookxml.core.exception.CreatorException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TextCreator
implements Creator {
    public static String SRC_ATTR = "src";
    private static final Creator s_instance = new TextCreator();

    public static Creator getInstance() {
        return s_instance;
    }

    private TextCreator() {
    }

    public Object create(String parentTag, Element elm, Object parentObj, String value, DecodeEngine decodeEngine) throws CreatorException {
        try {
            String srcAttr = elm.getAttribute(SRC_ATTR);
            if (srcAttr != null && srcAttr.length() > 0) {
                return TextCreator.readText(srcAttr, decodeEngine.getCookXml().getClassLoader());
            }
            Node node = elm.getFirstChild();
            if (node != null && node instanceof CharacterData) {
                return ((CharacterData)node).getData();
            }
            return null;
        }
        catch (Exception ex) {
            throw new CreatorException(decodeEngine, ex, this, parentTag, elm, parentObj, value);
        }
    }

    public Object editFinished(String parentTag, Element elm, Object parentObj, Object obj, DecodeEngine decodeEngine) throws CookXmlException {
        return obj;
    }

    public static String readText(String input) throws IOException {
        return TextCreator.readText(input, CookXml.getDefaultClassLoader());
    }

    public static String readText(String input, ClassLoader classLoader) throws IOException {
        String str;
        InputStream is = classLoader.getResourceAsStream(input);
        if (is == null) {
            is = new FileInputStream(input);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuffer strBuffer = new StringBuffer();
        while ((str = reader.readLine()) != null) {
            strBuffer.append(str).append("\n");
        }
        reader.close();
        return strBuffer.toString();
    }
}

