/*
 * Decompiled with CFR 0.152.
 */
package cookxml.core.converter;

import cookxml.core.DecodeEngine;
import cookxml.core.converter.Converter;
import cookxml.core.exception.ConverterException;
import java.net.URL;

public class URLConverter
implements Converter {
    private static final Converter s_instance = new URLConverter();

    public static Converter getInstance() {
        return s_instance;
    }

    private URLConverter() {
    }

    public Object convert(String value, DecodeEngine decodeEngine) throws ConverterException {
        try {
            URL url = decodeEngine.getCookXml().getClassLoader().getResource(value);
            if (url != null) {
                return url;
            }
            return new URL(value);
        }
        catch (Exception ex) {
            throw new ConverterException(decodeEngine, (Throwable)ex, this, value);
        }
    }
}

