/*
 * Decompiled with CFR 0.152.
 */
package cookxml.core.creator;

import cookxml.core.CookXml;
import cookxml.core.DecodeEngine;
import cookxml.core.Helper;
import cookxml.core.creator.Creator;
import cookxml.core.exception.CookXmlException;
import cookxml.core.exception.CreatorException;
import cookxml.core.exception.NoDefaultConstructorException;
import java.lang.reflect.Constructor;
import org.w3c.dom.Element;

public class HelperCreator
implements Creator {
    public static final Class[] EMPTY_CLASS_PARAM = new Class[0];
    public static final Object[] EMPTY_OBJECT_PARAM = new Object[0];
    private final Constructor m_ctor;

    public static Creator getCreator(Class targetClass) throws CookXmlException {
        if (!Helper.class.isAssignableFrom(targetClass)) {
            CookXml.getDefaultExceptionHandler().handleException(null, new NoDefaultConstructorException(targetClass));
            return null;
        }
        try {
            Constructor ctor = targetClass.getConstructor(EMPTY_CLASS_PARAM);
            return new HelperCreator(ctor);
        }
        catch (Exception ex) {
            CookXml.getDefaultExceptionHandler().handleException(null, new NoDefaultConstructorException(targetClass));
            return null;
        }
    }

    private HelperCreator(Constructor ctor) {
        this.m_ctor = ctor;
    }

    public Object create(String parentTag, Element elm, Object parentObj, String value, DecodeEngine decodeEngine) throws CreatorException {
        try {
            decodeEngine.setDoAdd(false);
            return this.m_ctor.newInstance(EMPTY_OBJECT_PARAM);
        }
        catch (Exception ex) {
            throw new CreatorException(decodeEngine, ex, this, parentTag, elm, parentObj, value);
        }
    }

    public Object editFinished(String parentTag, Element elm, Object parentObj, Object obj, DecodeEngine decodeEngine) throws CookXmlException {
        if (obj == null) {
            return null;
        }
        try {
            obj = ((Helper)obj).getFinalObject();
        }
        catch (Exception ex) {
            decodeEngine.handleException(null, new CookXmlException(null, decodeEngine, null, ex));
            return null;
        }
        decodeEngine.addChild(parentTag, elm, parentObj, obj);
        return obj;
    }
}

