/*
 * Decompiled with CFR 0.152.
 */
package cookxml.core.setter;

import cookxml.core.DecodeEngine;
import cookxml.core.FunctionHandler;
import cookxml.core.Handler;
import cookxml.core.VariableHandler;
import cookxml.core.exception.NoHandlerException;
import cookxml.core.exception.SetterException;
import cookxml.core.setter.Setter;

public class DefaultSetter
implements Setter {
    public static String PREFIX = "set";
    private static final Setter s_instance = new DefaultSetter();

    public static Setter getInstance() {
        return s_instance;
    }

    private DefaultSetter() {
    }

    public void setAttribute(String tag, String attr, Object obj, Object value, DecodeEngine decodeEngine) throws SetterException {
        try {
            Handler handler = decodeEngine.getHandler(tag, attr);
            if (handler == null) {
                String funcName;
                Class<?> valueClass = null;
                if (value != null && !(value instanceof String)) {
                    valueClass = value.getClass();
                }
                if ((handler = FunctionHandler.getHandler(obj, funcName = PREFIX + attr, valueClass)) == null) {
                    handler = VariableHandler.getHandler(obj, attr, valueClass);
                }
                if (handler != null) {
                    decodeEngine.setHandler(tag, attr, handler);
                }
            }
            if (handler != null) {
                handler.invoke(obj, value, decodeEngine);
                return;
            }
        }
        catch (Exception ex) {
            throw new SetterException(decodeEngine, ex, this, tag, attr, obj, value);
        }
        throw new SetterException(decodeEngine, new NoHandlerException(decodeEngine, tag, attr, obj, value), this, tag, attr, obj, value);
    }
}

