/*
 * Decompiled with CFR 0.152.
 */
package cookxml.cookswt.creator;

import cookxml.cookswt.exception.BadStyleException;
import cookxml.cookswt.exception.NoWidgetConstructorException;
import cookxml.core.CookXml;
import cookxml.core.DecodeEngine;
import cookxml.core.creator.Creator;
import cookxml.core.exception.CookXmlException;
import cookxml.core.exception.CreatorException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.StringTokenizer;
import org.eclipse.swt.SWT;
import org.w3c.dom.Element;

public class WidgetCreator
implements Creator {
    public static String STYLE_ATTR = "style";
    private final Constructor m_ctor;
    static /* synthetic */ Class class$org$eclipse$swt$widgets$Widget;

    public static Creator getCreator(Class targetClass) throws CookXmlException {
        try {
            Constructor<?>[] ctors = targetClass.getConstructors();
            for (int i = 0; i < ctors.length; ++i) {
                Constructor<?> ctor = ctors[i];
                Class<?>[] params = ctor.getParameterTypes();
                if (params.length != 2 || !(class$org$eclipse$swt$widgets$Widget == null ? WidgetCreator.class$("org.eclipse.swt.widgets.Widget") : class$org$eclipse$swt$widgets$Widget).isAssignableFrom(params[0]) || !"int".equals(params[1].getName())) continue;
                return new WidgetCreator(ctor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CookXml.getDefaultExceptionHandler().handleException(null, (Exception)((Object)new NoWidgetConstructorException(targetClass)));
        return null;
    }

    private WidgetCreator(Constructor ctor) {
        this.m_ctor = ctor;
    }

    public Object create(String parentTag, Element elm, Object parentObj, String value, DecodeEngine decodeEngine) throws CreatorException {
        try {
            Object widgetParent = parentObj;
            Class<?> targetClass = this.m_ctor.getParameterTypes()[0];
            while (widgetParent != null && !targetClass.isInstance(widgetParent)) {
                widgetParent = decodeEngine.getParent(widgetParent);
            }
            if (widgetParent == null) {
                return null;
            }
            int style = WidgetCreator.getStyle(elm, decodeEngine);
            decodeEngine.setDoAdd(false);
            return this.m_ctor.newInstance(widgetParent, new Integer(style));
        }
        catch (Exception ex) {
            throw new CreatorException(decodeEngine, (Throwable)ex, (Creator)this, parentTag, elm, parentObj, value);
        }
    }

    public Object editFinished(String parentTag, Element elm, Object parentObj, Object obj, DecodeEngine decodeEngine) throws CookXmlException {
        decodeEngine.addChild(parentTag, elm, parentObj, obj);
        return obj;
    }

    public static int getStyle(Element elm, DecodeEngine decodeEngine) throws CookXmlException {
        return WidgetCreator.getStyle(elm, 0, decodeEngine);
    }

    public static int getStyle(Element elm, int defaultVal, DecodeEngine decodeEngine) throws CookXmlException {
        int returnVal = defaultVal;
        try {
            String value = elm.getAttribute(STYLE_ATTR);
            if (value == null || value.length() == 0) {
                return returnVal;
            }
            StringTokenizer tokenizer = new StringTokenizer(value, "|");
            do {
                String tok = tokenizer.nextToken().trim();
                Field field = (class$org$eclipse$swt$SWT == null ? WidgetCreator.class$("org.eclipse.swt.SWT") : class$org$eclipse$swt$SWT).getField(tok);
                returnVal |= field.getInt(null);
            } while (tokenizer.hasMoreElements());
        }
        catch (Exception ex) {
            decodeEngine.handleException(null, (Exception)((Object)new BadStyleException(SWT.class, elm.getAttribute(STYLE_ATTR))));
        }
        return returnVal;
    }
}

