/*
 * Decompiled with CFR 0.152.
 */
package cookxml.cookswt.setter;

import cookxml.cookswt.converter.ColorConverter;
import cookxml.cookswt.converter.ImageConverter;
import cookxml.cookswt.util.SwtUtils;
import cookxml.core.DecodeEngine;
import cookxml.core.exception.ConverterException;
import cookxml.core.exception.SetterException;
import cookxml.core.setter.DefaultSetter;
import cookxml.core.setter.Setter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;

public class ColorAndImageSetter
implements Setter {
    private static Setter s_instance = new ColorAndImageSetter();

    public static Setter getInstance() {
        return s_instance;
    }

    private ColorAndImageSetter() {
    }

    public void setAttribute(String tag, String attr, Object obj, Object value, DecodeEngine decodeEngine) throws SetterException {
        if (value instanceof String) {
            Color color = ColorConverter.getColor((String)value);
            if (color == null) {
                try {
                    value = ImageConverter.getInstance().convert((String)value, decodeEngine);
                }
                catch (ConverterException ex) {}
            } else {
                value = color;
            }
        }
        if (value == null) {
            throw new SetterException(decodeEngine, null, (Setter)this, tag, attr, obj, value);
        }
        DefaultSetter.getInstance().setAttribute(tag, attr, obj, value, decodeEngine);
        if (obj == null || value == null || !(obj instanceof Widget)) {
            return;
        }
        if (value instanceof Color) {
            SwtUtils.attachColorDisposeListener((Widget)obj, (Color)value);
        } else if (value instanceof Image) {
            SwtUtils.attachImageDisposeListener((Widget)obj, (Image)value);
        }
    }
}

