/*
 * Decompiled with CFR 0.152.
 */
package cookxml.cookswt.converter;

import cookxml.core.DecodeEngine;
import cookxml.core.converter.Converter;
import cookxml.core.exception.ConverterException;
import java.util.StringTokenizer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class FontConverter
implements Converter {
    private static final Converter s_instance = new FontConverter();

    public static Converter getInstance() {
        return s_instance;
    }

    private FontConverter() {
    }

    public Object convert(String value, DecodeEngine decodeEngine) throws ConverterException {
        try {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            String fontName = tokenizer.nextToken().trim();
            String styleStr = tokenizer.nextToken().trim().toLowerCase();
            String sizeStr = tokenizer.nextToken().trim();
            int type = 0;
            if (styleStr.indexOf("bold") >= 0) {
                type = 1;
            }
            if (styleStr.indexOf("italic") >= 0) {
                type |= 2;
            }
            if (fontName.length() == 0) {
                fontName = null;
            }
            return new Font((Device)Display.getCurrent(), fontName, Integer.parseInt(sizeStr), type);
        }
        catch (Exception ex) {
            throw new ConverterException(decodeEngine, (Throwable)ex, (Converter)this, value);
        }
    }
}

