/*
 * Decompiled with CFR 0.152.
 */
package cookxml.cookswt.util;

import cookxml.cookswt.util.ColorDisposeListener;
import cookxml.cookswt.util.CursorDisposeListener;
import cookxml.cookswt.util.DropDownListener;
import cookxml.cookswt.util.FontDisposeListener;
import cookxml.cookswt.util.ImageDisposeListener;
import java.util.HashMap;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class SwtUtils {
    public static boolean autoDisposeColor;
    public static boolean autoDisposeFont;
    public static boolean autoDisposeImage;
    public static boolean autoDisposeCursor;
    private static HashMap s_systemColorTable;
    private static HashMap s_systemCursorTable;
    private static HashMap s_systemImageTable;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static void setupSystemColorTable(Device device) {
        HashMap<Color, Color> colorTable = new HashMap<Color, Color>();
        for (int i = 0; i <= 35; ++i) {
            Color c = device.getSystemColor(i);
            colorTable.put(c, c);
        }
        s_systemColorTable = colorTable;
    }

    private static void setupSystemCursorTable(Display display) {
        HashMap<Cursor, Cursor> cursorTable = new HashMap<Cursor, Cursor>();
        for (int i = 0; i <= 21; ++i) {
            Cursor c = display.getSystemCursor(i);
            cursorTable.put(c, c);
        }
        s_systemCursorTable = cursorTable;
    }

    private static void setupSystemImageTable(Display display) {
        HashMap<Image, Image> imageTable = new HashMap<Image, Image>();
        Image image = display.getSystemImage(1);
        imageTable.put(image, image);
        image = display.getSystemImage(2);
        imageTable.put(image, image);
        image = display.getSystemImage(4);
        imageTable.put(image, image);
        image = display.getSystemImage(8);
        imageTable.put(image, image);
        image = display.getSystemImage(16);
        imageTable.put(image, image);
        s_systemImageTable = imageTable;
    }

    public static boolean isSystemColor(Color color, Device device) {
        if (s_systemColorTable == null) {
            SwtUtils.setupSystemColorTable(device);
        }
        return s_systemColorTable.get(color) == color;
    }

    public static boolean isSystemCursor(Cursor cursor, Display display) {
        if (s_systemCursorTable == null) {
            SwtUtils.setupSystemCursorTable(display);
        }
        return s_systemCursorTable.get(cursor) == cursor;
    }

    public static boolean isSystemImage(Image image, Display display) {
        if (s_systemImageTable == null) {
            SwtUtils.setupSystemImageTable(display);
        }
        return s_systemImageTable.get(image) == image;
    }

    public static boolean isSystemFont(Font font, Device device) {
        return device.getSystemFont() == font;
    }

    public static void disposeColor(Color color, Device device) {
        if (color.isDisposed()) {
            return;
        }
        if (!SwtUtils.isSystemColor(color, device)) {
            if (!$assertionsDisabled && !SwtUtils.disposeDebug("Dispose color: " + color)) {
                throw new AssertionError();
            }
            color.dispose();
        }
    }

    public static void disposeImage(Image image, Display device) {
        if (image.isDisposed()) {
            return;
        }
        if (!SwtUtils.isSystemImage(image, device)) {
            if (!$assertionsDisabled && !SwtUtils.disposeDebug("Dispose image: " + image)) {
                throw new AssertionError();
            }
            image.dispose();
        }
    }

    public static void attachColorDisposeListener(Widget widget, Color color) {
        if (autoDisposeColor && !SwtUtils.isSystemColor(color, (Device)widget.getDisplay())) {
            widget.addDisposeListener((DisposeListener)new ColorDisposeListener(color));
        }
    }

    public static void attachCursorDisposeListener(Widget widget, Cursor cursor) {
        if (autoDisposeCursor && !SwtUtils.isSystemCursor(cursor, widget.getDisplay())) {
            widget.addDisposeListener((DisposeListener)new CursorDisposeListener(cursor));
        }
    }

    public static void attachFontDisposeListener(Widget widget, Font font) {
        if (autoDisposeFont && !SwtUtils.isSystemFont(font, (Device)widget.getDisplay())) {
            widget.addDisposeListener((DisposeListener)new FontDisposeListener(font));
        }
    }

    public static void attachImageDisposeListener(Widget widget, Image image) {
        if (autoDisposeImage && !SwtUtils.isSystemImage(image, widget.getDisplay())) {
            widget.addDisposeListener((DisposeListener)new ImageDisposeListener(image));
        }
    }

    public static void attachToolItemDropDownMenu(ToolItem item, Menu menu) {
        item.addSelectionListener((SelectionListener)new DropDownListener(menu));
    }

    public static void showDisplay(Display display) {
        Shell[] shells = display.getShells();
        for (int i = 0; i < shells.length; ++i) {
            if (shells[i].isDisposed() || shells[i].isVisible()) continue;
            shells[i].open();
        }
        while (!display.isDisposed()) {
            shells = display.getShells();
            boolean canExit = true;
            for (int i = 0; i < shells.length; ++i) {
                if (shells[i].isDisposed()) continue;
                canExit = false;
                break;
            }
            if (canExit) break;
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!display.isDisposed()) {
            display.dispose();
        }
    }

    public static boolean disposeDebug(String msg) {
        System.out.println(msg);
        return true;
    }

    static {
        $assertionsDisabled = !SwtUtils.class.desiredAssertionStatus();
        autoDisposeColor = true;
        autoDisposeFont = true;
        autoDisposeImage = true;
        autoDisposeCursor = true;
    }
}

