/*
 * Decompiled with CFR 0.152.
 */
package cookxml.core;

import cookxml.core.CleanupHook;
import cookxml.core.CookXml;
import cookxml.core.Handler;
import cookxml.core.NoAdd;
import cookxml.core.TagLibrary;
import cookxml.core.VarLookup;
import cookxml.core.adder.Adder;
import cookxml.core.adder.CallFunctionAdder;
import cookxml.core.creator.Creator;
import cookxml.core.creator.IdReferenceCreator;
import cookxml.core.creator.VarReferenceCreator;
import cookxml.core.exception.AdderException;
import cookxml.core.exception.CleanupException;
import cookxml.core.exception.CookXmlException;
import cookxml.core.exception.CreatorException;
import cookxml.core.exception.FuncAdderException;
import cookxml.core.exception.NoAdderException;
import cookxml.core.exception.NoCreatorException;
import cookxml.core.exception.NoSetterException;
import cookxml.core.exception.SetterException;
import cookxml.core.exception.VarLookupException;
import cookxml.core.exceptionhandler.ExceptionHandler;
import cookxml.core.setter.Setter;
import cookxml.core.stringhook.StringHook;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DecodeEngine
implements ExceptionHandler {
    public static String ID_ATTR = "id";
    public static String IDREF_ATTR = "idref";
    public static String TAG_ATTR = "tag";
    public static String CTOR_ATTR = "ctor";
    public static String SETAS_ATTR = "setas";
    public static String FUNC_ATTR = "func";
    public static String VAR_ATTR = "var";
    public static String VARREF_ATTR = "varref";
    public static String ADD_ATTR = "add";
    private static Set s_reservedAttr;
    private final CookXml m_cookXml;
    private final Map m_parentMap;
    private final Map m_handlerMap;
    private final VarLookup m_varLookup;
    private Element m_currentElm;
    private String m_currentTag;
    private StringHook m_stringHook;
    private Document m_document;
    private boolean m_doAdd;
    private boolean m_doProcessChildren;
    private final Stack m_dataStack;
    private HashMap m_properties;
    private LinkedList m_cleanupList;

    public static void configure() {
        s_reservedAttr = new HashSet();
        s_reservedAttr.add(ID_ATTR);
        s_reservedAttr.add(IDREF_ATTR);
        s_reservedAttr.add(CTOR_ATTR);
        s_reservedAttr.add(TAG_ATTR);
        s_reservedAttr.add(SETAS_ATTR);
        s_reservedAttr.add(FUNC_ATTR);
        s_reservedAttr.add(VAR_ATTR);
        s_reservedAttr.add(VARREF_ATTR);
        s_reservedAttr.add(ADD_ATTR);
    }

    public static DecodeEngine createDecodeEngine(CookXml cookXml, VarLookup varLookup, StringHook stringHook) {
        return new DecodeEngine(cookXml, varLookup, stringHook);
    }

    public static Object decode(Document document, CookXml cookXml, VarLookup varLookup, StringHook stringHook) throws CookXmlException {
        return DecodeEngine.decode(null, document, null, cookXml, varLookup, stringHook);
    }

    public static Object decode(String parentTag, Document document, Object parentObj, CookXml cookXml, VarLookup varLookup, StringHook stringHook) throws CookXmlException {
        DecodeEngine decodeEngine = DecodeEngine.createDecodeEngine(cookXml, varLookup, stringHook);
        decodeEngine.setDocument(document);
        return decodeEngine.decodeElement(parentTag, document.getDocumentElement(), parentObj);
    }

    public static Object decode(Element elm, CookXml cookXml, VarLookup varLookup, StringHook stringHook) throws CookXmlException {
        return DecodeEngine.decode(null, elm, null, cookXml, varLookup, stringHook);
    }

    public static Object decode(String parentTag, Element elm, Object parentObj, CookXml cookXml, VarLookup varLookup, StringHook stringHook) throws CookXmlException {
        DecodeEngine decodeEngine = DecodeEngine.createDecodeEngine(cookXml, varLookup, stringHook);
        return decodeEngine.decodeElement(parentTag, elm, parentObj);
    }

    private DecodeEngine(CookXml cookXml, VarLookup varLookup, StringHook stringHook) {
        this.m_cookXml = cookXml;
        this.m_varLookup = varLookup;
        this.m_parentMap = new HashMap();
        this.m_handlerMap = new HashMap();
        this.m_stringHook = stringHook;
        this.m_dataStack = new Stack();
    }

    public DecodeEngine newInstance() {
        return new DecodeEngine(this.m_cookXml, this.m_varLookup, this.m_stringHook);
    }

    public Object decodeElement(Element elm) throws CookXmlException {
        return this.decodeElement(null, elm, null);
    }

    public Object decodeElement(String parentTag, Element elm, Object parentObj) throws CookXmlException {
        String newTag;
        String tag;
        this.m_currentTag = tag = elm.getTagName();
        this.m_currentElm = elm;
        this.m_doAdd = true;
        this.m_doProcessChildren = true;
        CookXml cookXml = this.m_cookXml;
        TagLibrary tagLibrary = cookXml.getTagLibrary();
        Object obj = null;
        Attr attrNode = elm.getAttributeNode(IDREF_ATTR);
        Creator creator = null;
        if (attrNode != null) {
            creator = IdReferenceCreator.getInstance();
        } else {
            attrNode = elm.getAttributeNode(VARREF_ATTR);
            if (attrNode != null) {
                creator = VarReferenceCreator.getInstance();
            }
        }
        if (creator != null) {
            try {
                obj = creator.create(parentTag, elm, parentObj, attrNode.getValue(), this);
            }
            catch (Exception ex2) {
                CreatorException ex2;
                if (!(ex2 instanceof CreatorException) || ((CreatorException)ex2).creator != creator) {
                    ex2 = new CreatorException(this, ex2, creator, parentTag, elm, parentObj, attrNode.getValue());
                }
                this.handleException(null, ex2);
            }
        } else {
            creator = tagLibrary.getCreator(tag);
            if (creator == null) {
                this.handleException(null, new NoCreatorException(this, tag, parentTag, elm, parentObj));
                return null;
            }
            String ctorAttr = elm.getAttribute(CTOR_ATTR);
            if (this.m_stringHook != null) {
                ctorAttr = this.m_stringHook.getTranslatedString(tag, null, CTOR_ATTR, ctorAttr, this);
            }
            try {
                obj = creator.create(parentTag, elm, parentObj, ctorAttr, this);
            }
            catch (Exception ex3) {
                CreatorException ex3;
                if (!(ex3 instanceof CreatorException) || ((CreatorException)ex3).creator != creator) {
                    ex3 = new CreatorException(this, ex3, creator, parentTag, elm, parentObj, ctorAttr);
                }
                this.handleException(null, ex3);
            }
        }
        if (cookXml.getRootObject() == null) {
            cookXml.setRootObject(obj);
        }
        if ((newTag = elm.getAttribute(TAG_ATTR)) != null && newTag.length() > 0) {
            this.m_currentTag = newTag;
        }
        tag = this.m_currentTag;
        String id = elm.getAttribute(ID_ATTR);
        if (id != null && id.length() > 0) {
            this.m_cookXml.setId(id, this.m_currentTag, obj);
        } else {
            id = null;
        }
        if (obj == null) {
            return null;
        }
        this.setParent(parentObj, obj);
        NamedNodeMap attributes = elm.getAttributes();
        int size = attributes.getLength();
        for (int i = 0; i < size; ++i) {
            try {
                this.decodeAttribute(tag, attributes.item(i), obj);
                continue;
            }
            catch (SetterException ex) {
                this.handleException(null, ex);
            }
        }
        if (!(obj instanceof NoAdd) && this.m_doAdd) {
            this.addChild(parentTag, elm, parentObj, obj);
        }
        if (this.m_doProcessChildren) {
            NodeList children = elm.getChildNodes();
            size = children.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = children.item(i);
                if (!(node instanceof Element)) continue;
                this.decodeElement(tag, (Element)node, obj);
            }
        }
        try {
            Object newObj = creator.editFinished(parentTag, elm, parentObj, obj, this);
            if (newObj != obj && id != null) {
                this.m_cookXml.setId(id, this.m_currentTag, newObj);
            }
            return newObj;
        }
        catch (Exception ex4) {
            CookXmlException ex4;
            if (!(ex4 instanceof CookXmlException)) {
                ex4 = new CookXmlException(null, this, null, ex4);
            }
            this.handleException(null, ex4);
            return obj;
        }
    }

    private void decodeAttribute(String tag, Node attrib, Object obj) throws SetterException {
        String attr = attrib.getNodeName();
        String value = attrib.getNodeValue();
        if (s_reservedAttr.contains(attr)) {
            return;
        }
        this.callSetter(tag, attr, obj, value);
    }

    public void callSetter(String tag, String attr, Object obj, Object value) throws SetterException {
        TagLibrary tagLibrary = this.m_cookXml.getTagLibrary();
        Setter setter = tagLibrary.getSetter(tag, attr);
        if (setter == null && (setter = tagLibrary.getSetter(tag, null)) == null && (setter = tagLibrary.getSetter(null, attr)) == null && (setter = tagLibrary.getSetter(null, null)) == null) {
            throw new NoSetterException(this, tag, attr, obj, value);
        }
        try {
            if (this.m_stringHook != null && value instanceof String) {
                value = this.m_stringHook.getTranslatedString(tag, obj, attr, (String)value, this);
            }
            setter.setAttribute(tag, attr, obj, value, this);
        }
        catch (Exception ex2) {
            SetterException ex2;
            if (!(ex2 instanceof SetterException) || ((SetterException)ex2).setter != setter) {
                ex2 = new SetterException(this, ex2, setter, tag, attr, obj, value);
            }
            throw (SetterException)ex2;
        }
    }

    public void addChild(String tag, Element elm, Object parentObj, Object childObj) throws CookXmlException {
        Exception newEx;
        String varAttr = elm.getAttribute(VAR_ATTR);
        try {
            if (varAttr != null && varAttr.length() > 0) {
                if (this.m_varLookup == null) {
                    throw new VarLookupException(this, null, this.m_varLookup, varAttr, childObj, false);
                }
                this.m_varLookup.setVariable(varAttr, childObj, this);
            }
        }
        catch (Exception ex2) {
            VarLookupException ex2;
            if (!(ex2 instanceof VarLookupException) || ((VarLookupException)ex2).varLookup != this.m_varLookup) {
                ex2 = new VarLookupException(this, ex2, this.m_varLookup, varAttr, childObj, false);
            }
            this.handleException(null, ex2);
        }
        if (parentObj == null || tag == null || tag.length() == 0) {
            return;
        }
        String setterAttr = elm.getAttribute(SETAS_ATTR);
        if (setterAttr != null && setterAttr.length() > 0) {
            try {
                this.callSetter(tag, setterAttr, parentObj, childObj);
            }
            catch (Exception ex) {
                this.handleException(null, ex);
            }
            return;
        }
        String funcAttr = elm.getAttribute(FUNC_ATTR);
        if (funcAttr != null && funcAttr.length() > 0) {
            FuncAdderException newEx2;
            try {
                if (CallFunctionAdder.add(tag, parentObj, childObj, this, null, null, funcAttr, null)) {
                    return;
                }
                newEx2 = new FuncAdderException(this, null, funcAttr, tag, parentObj, childObj);
            }
            catch (Exception ex) {
                newEx2 = new FuncAdderException(this, (Throwable)ex, funcAttr, tag, parentObj, childObj);
            }
            this.handleException(null, newEx2);
            return;
        }
        String addAttr = elm.getAttribute(ADD_ATTR);
        if (addAttr != null && "false".equalsIgnoreCase(addAttr)) {
            return;
        }
        TagLibrary tagLibrary = this.m_cookXml.getTagLibrary();
        Adder adder = tagLibrary.getAdder(tag);
        if (adder == null && (adder = tagLibrary.getAdder(null)) == null) {
            this.handleException(null, new NoAdderException(this, tag, parentObj, childObj));
            return;
        }
        try {
            if (adder.add(tag, parentObj, childObj, this)) {
                return;
            }
            newEx = new AdderException(this, null, adder, tag, parentObj, childObj);
        }
        catch (Exception ex) {
            newEx = !(ex instanceof AdderException) || ((AdderException)ex).adder != adder ? new AdderException(this, ex, adder, tag, parentObj, childObj) : ex;
        }
        this.handleException(null, newEx);
    }

    public CookXml getCookXml() {
        return this.m_cookXml;
    }

    public Object getParent(Object child) {
        return this.m_parentMap.get(child);
    }

    public Element getCurrentElement() {
        return this.m_currentElm;
    }

    public void setParent(Object parent, Object child) {
        this.m_parentMap.put(child, parent);
    }

    public VarLookup getVarLookup() {
        return this.m_varLookup;
    }

    public Object getVariable(String name) throws VarLookupException {
        if (this.m_varLookup == null) {
            return null;
        }
        return this.m_varLookup.getVariable(name, this);
    }

    public void setVariable(String name, Object value) throws VarLookupException {
        if (this.m_varLookup == null) {
            return;
        }
        this.m_varLookup.setVariable(name, value, this);
    }

    public Handler getHandler(String tag, String attr) {
        Handler handler = (Handler)this.m_handlerMap.get(tag + "/" + attr);
        return handler;
    }

    public void setHandler(String tag, String attr, Handler handler) {
        this.m_handlerMap.put(tag + "/" + attr, handler);
    }

    public String getCurrentTag() {
        return this.m_currentTag;
    }

    public void setCurrentTag(String currentTag) {
        this.m_currentTag = currentTag;
    }

    public StringHook getStringHook() {
        return this.m_stringHook;
    }

    public void setStringHook(StringHook stringHook) {
        this.m_stringHook = stringHook;
    }

    public Document getDocument() {
        return this.m_document;
    }

    public void setDocument(Document document) {
        this.m_document = document;
    }

    public void pushData(Object data) {
        this.m_dataStack.push(data);
    }

    public Object popData() {
        if (this.m_dataStack.size() == 0) {
            return null;
        }
        return this.m_dataStack.pop();
    }

    public Object peekData() {
        if (this.m_dataStack.size() == 0) {
            return null;
        }
        return this.m_dataStack.peek();
    }

    public void setDoAdd(boolean b) {
        this.m_doAdd = b;
    }

    public void setDoProcessChildren(boolean b) {
        this.m_doProcessChildren = b;
    }

    public void handleException(String msg, Exception ex) throws CookXmlException {
        this.getCookXml().getExceptionHandler().handleException(msg, ex);
    }

    public Object setProperty(String key, Object value) {
        HashMap<String, Object> properties = this.m_properties;
        if (properties == null) {
            this.m_properties = properties = new HashMap<String, Object>();
        }
        Object oldValue = properties.get(key);
        properties.put(key, value);
        return oldValue;
    }

    public Object getProperty(String key) {
        HashMap properties = this.m_properties;
        if (properties == null) {
            return null;
        }
        return properties.get(key);
    }

    public void addCleanupHook(CleanupHook hook) {
        if (hook == null) {
            return;
        }
        if (this.m_cleanupList == null) {
            this.m_cleanupList = new LinkedList();
        }
        if (!this.m_cleanupList.contains(hook)) {
            this.m_cleanupList.add(hook);
        }
    }

    public void removeCleanupHook(CleanupHook hook) {
        if (this.m_cleanupList != null) {
            this.m_cleanupList.remove(hook);
        }
    }

    public void cleanup() throws CleanupException {
        if (this.m_cleanupList != null) {
            Iterator iter = this.m_cleanupList.iterator();
            while (iter.hasNext()) {
                CleanupHook hook = (CleanupHook)iter.next();
                try {
                    hook.cleanup(this);
                }
                catch (CleanupException ex) {
                    this.handleException(null, ex);
                }
                catch (Exception ex) {
                    this.handleException(null, new CleanupException(this, ex, hook));
                }
            }
        }
    }

    static {
        DecodeEngine.configure();
    }
}

