/*
 * Decompiled with CFR 0.152.
 */
package cookxml.core;

import cookxml.core.adder.Adder;
import cookxml.core.converter.Converter;
import cookxml.core.creator.Creator;
import cookxml.core.setter.Setter;
import java.util.HashMap;
import java.util.Map;

public class TagLibrary {
    private final TagLibrary m_parent;
    private final Map m_creatorMap;
    private final Map m_converterMap;
    private final Map m_adderMap;
    private final Map m_setterMap;

    public TagLibrary() {
        this(null);
    }

    public TagLibrary(TagLibrary parentTagLibrary) {
        this.m_parent = parentTagLibrary;
        this.m_creatorMap = new HashMap();
        this.m_converterMap = new HashMap();
        this.m_adderMap = new HashMap();
        this.m_setterMap = new HashMap();
    }

    public Creator getCreator(String tag) {
        Creator creator = (Creator)this.m_creatorMap.get(tag);
        if (creator == null && this.m_parent != null) {
            return this.m_parent.getCreator(tag);
        }
        return creator;
    }

    public Setter getSetter(String tag, String attr) {
        Setter setter;
        if (tag == null) {
            tag = "";
        }
        if (attr == null) {
            attr = "";
        }
        if ((setter = (Setter)this.m_setterMap.get(tag + "/" + attr)) == null && this.m_parent != null) {
            return this.m_parent.getSetter(tag, attr);
        }
        return setter;
    }

    public Adder getAdder(String tag) {
        Adder adder;
        if (tag == null) {
            tag = "";
        }
        if ((adder = (Adder)this.m_adderMap.get(tag)) == null && this.m_parent != null) {
            return this.m_parent.getAdder(tag);
        }
        return adder;
    }

    public Converter getConverter(Class targetClass) {
        Converter converter = (Converter)this.m_converterMap.get(targetClass);
        if (converter == null && this.m_parent != null) {
            return this.m_parent.getConverter(targetClass);
        }
        return converter;
    }

    public void setCreator(String tag, Creator creator) {
        this.m_creatorMap.put(tag, creator);
    }

    public void setSetter(String tag, String attr, Setter setter) {
        if (tag == null) {
            tag = "";
        }
        if (attr == null) {
            attr = "";
        }
        this.m_setterMap.put(tag + "/" + attr, setter);
    }

    public void setAdder(String tag, Adder adder) {
        if (tag == null) {
            tag = "";
        }
        this.m_adderMap.put(tag, adder);
    }

    public void setConverter(Class targetClass, Converter converter) {
        this.m_converterMap.put(targetClass, converter);
    }
}

