/*
 * Decompiled with CFR 0.152.
 */
package cookxml.core;

import cookxml.core.DecodeEngine;
import cookxml.core.Handler;
import cookxml.core.converter.Converter;
import cookxml.core.exception.HandlerException;
import cookxml.core.exception.VariableHandlerException;
import cookxml.core.util.ClassUtils;
import java.lang.reflect.Field;

public class VariableHandler
implements Handler {
    private final Field m_field;

    private VariableHandler(Field field) {
        this.m_field = field;
    }

    public boolean invoke(Object obj, Object value, DecodeEngine decodeEngine) throws HandlerException {
        try {
            Converter converter;
            Class<?> valueClass;
            if (value == null) {
                this.m_field.set(obj, value);
                return true;
            }
            Class targetClass = ClassUtils.getEquivalentClass(this.m_field.getType());
            if (targetClass.isAssignableFrom(valueClass = value.getClass())) {
                this.m_field.set(obj, value);
                return true;
            }
            if (value instanceof String && (converter = decodeEngine.getCookXml().getTagLibrary().getConverter(targetClass)) != null) {
                this.m_field.set(obj, converter.convert((String)value, decodeEngine));
                return true;
            }
        }
        catch (Exception ex) {
            throw new VariableHandlerException(decodeEngine, ex, obj, value, this.m_field);
        }
        throw new VariableHandlerException(decodeEngine, null, obj, value, this.m_field);
    }

    public String toString() {
        return this.m_field.toString();
    }

    public static Handler getHandler(Object obj, String fieldName, Class valueClass) {
        if (fieldName == null) {
            return null;
        }
        Field[] fields = obj.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.getName().equalsIgnoreCase(fieldName)) continue;
            if (valueClass == null) {
                return new VariableHandler(field);
            }
            Class targetClass = ClassUtils.getEquivalentClass(field.getType());
            if (!targetClass.isAssignableFrom(valueClass)) continue;
            return new VariableHandler(field);
        }
        return null;
    }
}

