/*
 * Decompiled with CFR 0.152.
 */
package cookxml.core.adder;

import cookxml.core.DecodeEngine;
import cookxml.core.FunctionHandler;
import cookxml.core.Handler;
import cookxml.core.adder.Adder;
import cookxml.core.exception.AdderException;

public class CallFunctionAdder
implements Adder {
    private final String m_funcName;
    private final Class m_childClass;
    private final Class m_parentClass;

    public CallFunctionAdder(String funcName, Class parentClass, Class childClass) {
        this.m_funcName = funcName;
        this.m_childClass = childClass;
        this.m_parentClass = parentClass;
    }

    public boolean add(String parentTag, Object parent, Object child, DecodeEngine decodeEngine) throws AdderException {
        if (parent == null || this.m_parentClass != null && !this.m_parentClass.isInstance(parent) || this.m_childClass != null && !this.m_childClass.isInstance(child)) {
            return false;
        }
        return CallFunctionAdder.add(parentTag, parent, child, decodeEngine, this.m_parentClass, this.m_childClass, this.m_funcName, this);
    }

    public static boolean add(String tag, Object parent, Object child, DecodeEngine decodeEngine, Class parentClass, Class childClass, String funcName, Adder adder) throws AdderException {
        if (parent == null) {
            return false;
        }
        if (parentClass != null && !parentClass.isInstance(parent) || childClass != null && !childClass.isInstance(child)) {
            throw new AdderException(decodeEngine, null, adder, tag, parent, child);
        }
        if (childClass == null && child != null) {
            childClass = child.getClass();
        }
        try {
            Handler handler = decodeEngine.getHandler(tag, funcName + "/" + childClass);
            if (handler == null && (handler = FunctionHandler.getHandler(parent, funcName, childClass)) != null) {
                decodeEngine.setHandler(tag, funcName + "/" + childClass, handler);
            }
            if (handler != null) {
                handler.invoke(parent, child, decodeEngine);
                return true;
            }
        }
        catch (Exception ex) {
            throw new AdderException(decodeEngine, ex, adder, tag, parent, child);
        }
        throw new AdderException(decodeEngine, null, adder, tag, parent, child);
    }
}

