/*
 * Decompiled with CFR 0.152.
 */
package cookxml.core.converter;

import cookxml.core.DecodeEngine;
import cookxml.core.IdReference;
import cookxml.core.converter.Converter;
import cookxml.core.exception.ConverterException;

public class ObjectConverter
implements Converter {
    public static String IDREF_PREFIX = "id:";
    public static String VARREF_PREFIX = "var:";
    private static final Converter s_instance = new ObjectConverter();

    public static Converter getInstance() {
        return s_instance;
    }

    private ObjectConverter() {
    }

    public Object convert(String value, DecodeEngine decodeEngine) throws ConverterException {
        try {
            if ("null".equals(value)) {
                return null;
            }
            if (value.startsWith(IDREF_PREFIX)) {
                IdReference idref = decodeEngine.getCookXml().getId(value.substring(IDREF_PREFIX.length()));
                return idref.object;
            }
            if (value.startsWith(VARREF_PREFIX)) {
                return decodeEngine.getVariable(value.substring(VARREF_PREFIX.length()));
            }
        }
        catch (Exception ex) {
            throw new ConverterException(decodeEngine, (Throwable)ex, this, value);
        }
        throw new ConverterException(decodeEngine, null, this, value);
    }
}

